/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.parser;

import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import io.github.goldfish07.reschiper.plugin.bundle.ResourceMapping;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class ResourcesMappingParser {
    private static final Pattern MAP_DIR_PATTERN = Pattern.compile("^\\s+(.*)->(.*)");
    private static final Pattern MAP_RES_PATTERN = Pattern.compile("^\\s+(.*):(.*)->(.*)");
    private final Path mappingPath;

    public ResourcesMappingParser(Path mappingPath) {
        FilePreconditions.checkFileExistsAndReadable((Path)mappingPath);
        this.mappingPath = mappingPath;
    }

    public ResourceMapping parse() throws IOException {
        ResourceMapping mapping = new ResourceMapping();
        FileReader fr = new FileReader(this.mappingPath.toFile());
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        while (line != null) {
            if (line.isEmpty()) {
                line = br.readLine();
                continue;
            }
            System.out.println("Res: " + line);
            if (!line.contains(":")) {
                mat = MAP_DIR_PATTERN.matcher(line);
                if (mat.find()) {
                    rawName = mat.group(1).trim();
                    obfuscateName = mat.group(2).trim();
                    if (!line.contains("/") || line.contains(".")) {
                        throw new IllegalArgumentException("Unexpected resource dir: " + line);
                    }
                    mapping.putDirMapping(rawName, obfuscateName);
                }
            } else {
                mat = MAP_RES_PATTERN.matcher(line);
                if (mat.find()) {
                    rawName = mat.group(2).trim();
                    obfuscateName = mat.group(3).trim();
                    if (line.contains("/")) {
                        mapping.putEntryFileMapping(rawName, obfuscateName);
                    } else {
                        int packagePos = rawName.indexOf(".R.");
                        if (packagePos == -1) {
                            throw new IllegalArgumentException(String.format("the mapping file packageName is malformed, it should be like com.github.goldfish07.ugc.R.attr.test, yours %s\n", rawName));
                        }
                        mapping.putResourceMapping(rawName, obfuscateName);
                    }
                }
            }
            line = br.readLine();
        }
        br.close();
        fr.close();
        return mapping;
    }
}

