/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.command.extensions;

import com.android.bundle.Files;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import io.github.goldfish07.reschiper.plugin.bundle.AppBundleUtils;
import io.github.goldfish07.reschiper.plugin.operations.FileOperation;
import io.github.goldfish07.reschiper.plugin.operations.NativeLibrariesOperation;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import io.github.goldfish07.reschiper.plugin.utils.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleFileFilter {
    private static final Set<String> FILE_SIGN = new HashSet<String>((Collection<String>)ImmutableSet.of((Object)"META-INF/*.RSA", (Object)"META-INF/*.SF", (Object)"META-INF/*.MF"));
    private final ZipFile bundleZipFile;
    private final AppBundle rawAppBundle;
    private final Set<String> filterRules;
    private int filterTotalSize = 0;
    private int filterTotalCount = 0;

    public BundleFileFilter(Path bundlePath, AppBundle rawAppBundle, Set<String> filterRules) throws IOException {
        FilePreconditions.checkFileExistsAndReadable((Path)bundlePath);
        this.bundleZipFile = new ZipFile(bundlePath.toFile());
        this.rawAppBundle = rawAppBundle;
        if (filterRules == null) {
            filterRules = new HashSet<String>();
        }
        this.filterRules = filterRules;
        filterRules.addAll(FILE_SIGN);
    }

    public AppBundle filter() throws IOException {
        System.out.println("----------------------------------------");
        System.out.println(" Resource File Filter:");
        System.out.println("----------------------------------------");
        TimeClock timeClock = new TimeClock();
        HashMap<BundleModuleName, BundleModule> bundleModules = new HashMap<BundleModuleName, BundleModule>();
        for (Map.Entry entry : this.rawAppBundle.getModules().entrySet()) {
            bundleModules.put((BundleModuleName)entry.getKey(), this.filterBundleModule((BundleModule)entry.getValue()));
        }
        AppBundle appBundle = this.rawAppBundle.toBuilder().setBundleMetadata(this.filterMetaData()).setModules(ImmutableMap.copyOf(bundleModules)).build();
        System.out.printf(" \n Filtering completed in %s\n-----------------------------------------\n Reduced file count: %s\n Reduced file size: %s\n-----------------------------------------\n%n", timeClock.getElapsedTime(), this.filterTotalCount, FileOperation.getNetFileSizeDescription(this.filterTotalSize));
        return appBundle;
    }

    private BundleModule filterBundleModule(@NotNull BundleModule bundleModule) throws IOException {
        BundleModule.Builder builder = bundleModule.toBuilder();
        ArrayList<ModuleEntry> filteredModuleEntries = new ArrayList<ModuleEntry>();
        List entries = bundleModule.getEntries().stream().filter(entry -> {
            String filterRule = this.getMatchedFilterRule(entry.getPath());
            if (filterRule != null) {
                this.checkFilteredEntry((ModuleEntry)entry, filterRule);
                System.out.printf(" - %s%n", entry.getPath());
                filteredModuleEntries.add((ModuleEntry)entry);
                this.filterTotalSize += (int)AppBundleUtils.getZipEntrySize(this.bundleZipFile, entry, bundleModule);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        builder.setRawEntries(entries);
        this.filterTotalCount += filteredModuleEntries.size();
        Files.NativeLibraries nativeLibraries = this.updateLibDirectory(bundleModule, filteredModuleEntries);
        if (nativeLibraries != null) {
            builder.setNativeConfig(nativeLibraries);
        }
        return builder.build();
    }

    private Files.NativeLibraries updateLibDirectory(@NotNull BundleModule bundleModule, @NotNull List<ModuleEntry> entries) throws UnexpectedException {
        List<ModuleEntry> libEntries = entries.stream().filter(entry -> entry.getPath().startsWith(BundleModule.LIB_DIRECTORY)).toList();
        Files.NativeLibraries nativeLibraries = bundleModule.getNativeConfig().orElse(null);
        if (libEntries.isEmpty()) {
            return nativeLibraries;
        }
        if (nativeLibraries == null) {
            throw new UnexpectedException(String.format("can not find nativeLibraries file `native.pb` in %s module", bundleModule.getName().getName()));
        }
        Files.NativeLibraries filteredNativeLibraries = nativeLibraries;
        for (Files.TargetedNativeDirectory directory : nativeLibraries.getDirectoryList()) {
            int moduleNativeSize;
            int directoryNativeSize = libEntries.stream().filter(entry -> entry.getPath().startsWith(directory.getPath())).toList().size();
            if (directoryNativeSize <= 0 || directoryNativeSize != (moduleNativeSize = bundleModule.getEntries().stream().filter(entry -> entry.getPath().startsWith(directory.getPath())).toList().size())) continue;
            filteredNativeLibraries = NativeLibrariesOperation.removeDirectory(filteredNativeLibraries, directory.getPath());
        }
        return filteredNativeLibraries;
    }

    private BundleMetadata filterMetaData() {
        BundleMetadata.Builder builder = BundleMetadata.builder();
        Stream.of(this.rawAppBundle.getBundleMetadata()).map(BundleMetadata::getFileContentMap).map(ImmutableMap::entrySet).flatMap(Collection::stream).filter(entry -> {
            ZipPath entryZipPath = ZipPath.create((String)(AppBundle.METADATA_DIRECTORY + "/" + entry.getKey()));
            if (this.getMatchedFilterRule(entryZipPath) != null) {
                System.out.printf(" - %s%n", entryZipPath);
                ++this.filterTotalCount;
                this.filterTotalSize += (int)AppBundleUtils.getZipEntrySize(this.bundleZipFile, entryZipPath);
                return false;
            }
            return true;
        }).forEach(entry -> builder.addFile((ZipPath)entry.getKey(), (ByteSource)entry.getValue()));
        return builder.build();
    }

    private void checkFilteredEntry(@NotNull ModuleEntry entry, String filterRule) {
        if (!entry.getPath().startsWith(BundleModule.LIB_DIRECTORY) && !entry.getPath().startsWith(AppBundle.METADATA_DIRECTORY.toString())) {
            throw new UnsupportedOperationException(String.format("%s entry can not be filtered, please check the filter rule [%s].", entry.getPath(), filterRule));
        }
    }

    @Nullable
    private String getMatchedFilterRule(ZipPath zipPath) {
        for (String rule : this.filterRules) {
            Pattern filterPattern = Pattern.compile(Utils.convertToPatternString(rule));
            if (!filterPattern.matcher(zipPath.toString()).matches()) continue;
            return rule;
        }
        return null;
    }
}

