/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.bundle;

import com.android.tools.build.bundletool.io.AppBundleSerializer;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import io.github.goldfish07.reschiper.plugin.utils.TimeClock;
import java.io.IOException;
import java.nio.file.Path;

public class AppBundlePackager {
    private final Path output;
    private final AppBundle appBundle;

    public AppBundlePackager(AppBundle appBundle, Path output) {
        this.output = output;
        this.appBundle = appBundle;
        FilePreconditions.checkFileDoesNotExist((Path)output);
    }

    public void execute() throws IOException {
        System.out.println("----------------------------------------\n Resource Packaging:\n----------------------------------------\n- Packaging the bundle...");
        TimeClock timeClock = new TimeClock();
        AppBundleSerializer appBundleSerializer = new AppBundleSerializer();
        appBundleSerializer.writeToDisk(this.appBundle, this.output);
        System.out.printf("- Packaging completed in: %s%n\n", timeClock.getElapsedTime());
    }
}

