/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.android;

import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import io.github.goldfish07.reschiper.plugin.android.AndroidDebugKeyStoreHelper;
import io.github.goldfish07.reschiper.plugin.android.OpenJDKJarSigner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;

public class JarSigner {
    public void sign(File toBeSigned, Signature signature) throws IOException, InterruptedException {
        new OpenJDKJarSigner().sign(toBeSigned, signature);
    }

    public static void checkFlagPresent(Object object, Flag<String> flag) {
        Optional.ofNullable(object).orElseThrow(() -> (CommandExecutionException)CommandExecutionException.builder().withInternalMessage("Wrong properties: %s can not be empty", new Object[]{flag}).build());
    }

    public static void checkStringIsEmpty(String value, String name) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Wrong properties: %s can not be empty", name));
        }
    }

    public record Signature(Path storeFile, String storePassword, String keyAlias, String keyPassword) {
        public static final Signature DEBUG_SIGNATURE = AndroidDebugKeyStoreHelper.debugSigningConfig();

        public Signature(Path storeFile, String storePassword, String keyAlias, String keyPassword) {
            this.storeFile = storeFile;
            this.storePassword = storePassword;
            this.keyAlias = keyAlias;
            this.keyPassword = keyPassword;
            FilePreconditions.checkFileExistsAndReadable((Path)storeFile);
            JarSigner.checkStringIsEmpty(storePassword, "storePassword");
            JarSigner.checkStringIsEmpty(keyAlias, "keyAlias");
            JarSigner.checkStringIsEmpty(keyPassword, "keyPassword");
        }
    }
}

