/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.android;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLocation {
    public static final String FOLDER_DOT_ANDROID = ".android";
    public static final String FOLDER_AVD = "avd";
    private static String sPrefsLocation = null;
    private static String sAvdLocation = null;

    public static String getFolder() throws AndroidLocationException {
        File f;
        if (sPrefsLocation == null) {
            sPrefsLocation = AndroidLocation.findHomeFolder();
        }
        if (!(f = new File(sPrefsLocation)).exists()) {
            try {
                f.mkdirs();
            }
            catch (SecurityException e) {
                AndroidLocationException ale = new AndroidLocationException(String.format("Unable to create folder '%1$s'. This is the path of the preference folder expected by the Android tools.", sPrefsLocation));
                ale.initCause(e);
                throw ale;
            }
        } else if (f.isFile()) {
            throw new AndroidLocationException(String.format("%1$s is not a directory!\nThis is the path of the preference folder expected by the Android tools.", sPrefsLocation));
        }
        return sPrefsLocation;
    }

    @Nullable
    public static String getFolderWithoutWrites() {
        if (sPrefsLocation == null) {
            try {
                sPrefsLocation = AndroidLocation.findHomeFolder();
            }
            catch (AndroidLocationException e) {
                return null;
            }
        }
        return sPrefsLocation;
    }

    public static void checkAndroidSdkHome() throws AndroidLocationException {
        Global.ANDROID_SDK_HOME.validatePath(false);
    }

    public static String getAvdFolder() throws AndroidLocationException {
        if (sAvdLocation == null && !(sAvdLocation = AndroidLocation.findValidPath(Global.ANDROID_AVD_HOME)).endsWith(File.separator)) {
            sAvdLocation = sAvdLocation + File.separator;
        }
        return sAvdLocation;
    }

    @NotNull
    public static String getUserHomeFolder() throws AndroidLocationException {
        return AndroidLocation.findValidPath(Global.TEST_TMPDIR, Global.USER_HOME, Global.HOME);
    }

    @NotNull
    private static String findHomeFolder() throws AndroidLocationException {
        Object home = AndroidLocation.findValidPath(Global.ANDROID_SDK_HOME, Global.TEST_TMPDIR, Global.USER_HOME, Global.HOME);
        if (!((String)home).endsWith(File.separator)) {
            home = (String)home + File.separator;
        }
        return (String)home + FOLDER_DOT_ANDROID + File.separator;
    }

    public static void resetFolder() {
        sPrefsLocation = null;
        sAvdLocation = null;
    }

    @NotNull
    private static String findValidPath(Global ... vars) throws AndroidLocationException {
        for (Global var : vars) {
            String path = var.validatePath(true);
            if (path == null) continue;
            return path;
        }
        throw new AndroidLocationException("No valid path found.");
    }

    public static final class AndroidLocationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AndroidLocationException(String string) {
            super(string);
        }
    }

    private static enum Global {
        ANDROID_AVD_HOME("ANDROID_AVD_HOME", true, true),
        ANDROID_SDK_HOME("ANDROID_SDK_HOME", true, true),
        TEST_TMPDIR("TEST_TMPDIR", false, true),
        USER_HOME("user.home", true, false),
        HOME("HOME", false, true);

        final String mName;
        final boolean mIsSysProp;
        final boolean mIsEnvVar;

        private Global(String name, boolean isSysProp, boolean isEnvVar) {
            this.mName = name;
            this.mIsSysProp = isSysProp;
            this.mIsEnvVar = isEnvVar;
        }

        private static boolean isSdkRootWithoutDotAndroid(File folder) {
            return Global.subFolderExist(folder, "platforms") && Global.subFolderExist(folder, "platform-tools") && !Global.subFolderExist(folder, AndroidLocation.FOLDER_DOT_ANDROID);
        }

        private static boolean subFolderExist(File folder, String subFolder) {
            return new File(folder, subFolder).isDirectory();
        }

        @Nullable
        public String validatePath(boolean silent) throws AndroidLocationException {
            String path;
            if (this.mIsSysProp && (path = this.checkPath(System.getProperty(this.mName), silent)) != null) {
                return path;
            }
            if (this.mIsEnvVar) {
                path = this.checkPath(System.getenv(this.mName), silent);
                return path;
            }
            return null;
        }

        private String checkPath(String path, boolean silent) throws AndroidLocationException {
            if (path == null) {
                return null;
            }
            File file = new File(path);
            if (!file.isDirectory()) {
                return null;
            }
            if (this != ANDROID_SDK_HOME || !Global.isSdkRootWithoutDotAndroid(file)) {
                return path;
            }
            if (!silent) {
                throw new AndroidLocationException(String.format("ANDROID_SDK_HOME is set to the root of your SDK: %1$s\nThis is the path of the preference folder expected by the Android tools.\nIt should NOT be set to the same as the root of your SDK.\nPlease set it to a different folder or do not set it at all.\nIf this is not set we default to: %2$s", path, AndroidLocation.findValidPath(TEST_TMPDIR, USER_HOME, HOME)));
            }
            return null;
        }
    }
}

