/*
 * Decompiled with CFR 0.152.
 */
package io.github.goldfish07.reschiper.plugin.android;

import io.github.goldfish07.reschiper.plugin.android.AndroidLocation;
import io.github.goldfish07.reschiper.plugin.android.JarSigner;
import java.io.File;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class AndroidDebugKeyStoreHelper {
    public static final String DEFAULT_PASSWORD = "android";
    public static final String DEFAULT_ALIAS = "AndroidDebugKey";
    private static final Logger logger = Logger.getLogger(AndroidDebugKeyStoreHelper.class.getName());

    @Nullable
    public static JarSigner.Signature debugSigningConfig() {
        String debugKeystoreLocation = AndroidDebugKeyStoreHelper.defaultDebugKeystoreLocation();
        if (debugKeystoreLocation == null || !new File(debugKeystoreLocation).exists()) {
            return null;
        }
        return new JarSigner.Signature(Path.of(debugKeystoreLocation, new String[0]), DEFAULT_PASSWORD, DEFAULT_ALIAS, DEFAULT_PASSWORD);
    }

    @Nullable
    private static String defaultDebugKeystoreLocation() {
        try {
            String folder = AndroidLocation.getFolder();
            return folder + "debug.keystore";
        }
        catch (AndroidLocation.AndroidLocationException e) {
            logger.log(Level.SEVERE, "Error getting keystore folder", e);
            return null;
        }
    }
}

