/*
 * Decompiled with CFR 0.152.
 */
package io.github.gmazzo.publications.report;

import io.github.gmazzo.publications.report.ReportPublication;
import io.github.gmazzo.publications.report.ReportPublicationsFlowAction;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.flow.FlowAction;
import org.gradle.api.flow.FlowParameters;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J&\u0010\u000b\u001a\u00020\t*\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00100\u000eH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/gmazzo/publications/report/ReportPublicationsFlowAction;", "Lorg/gradle/api/flow/FlowAction;", "Lio/github/gmazzo/publications/report/ReportPublicationsFlowAction$Params;", "()V", "publicationsComparator", "Ljava/util/Comparator;", "Lio/github/gmazzo/publications/report/ReportPublication;", "Lkotlin/Comparator;", "execute", "", "parameters", "report", "Lorg/gradle/internal/logging/text/StyledTextOutput;", "publications", "Ljava/util/TreeMap;", "Lio/github/gmazzo/publications/report/ReportPublication$Repository;", "Ljava/util/TreeSet;", "Params", "plugin"})
@SourceDebugExtension(value={"SMAP\nReportPublicationsFlowAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportPublicationsFlowAction.kt\nio/github/gmazzo/publications/report/ReportPublicationsFlowAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n215#2,2:86\n215#2:88\n216#2:91\n1855#3,2:89\n*S KotlinDebug\n*F\n+ 1 ReportPublicationsFlowAction.kt\nio/github/gmazzo/publications/report/ReportPublicationsFlowAction\n*L\n27#1:86,2\n47#1:88\n47#1:91\n57#1:89,2\n*E\n"})
public abstract class ReportPublicationsFlowAction
implements FlowAction<Params> {
    @NotNull
    private final Comparator<ReportPublication> publicationsComparator;

    public ReportPublicationsFlowAction() {
        Function1[] function1Array = new Function1[]{publicationsComparator.1.INSTANCE, publicationsComparator.2.INSTANCE, publicationsComparator.3.INSTANCE};
        this.publicationsComparator = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    public void execute(@NotNull Params parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        StyledTextOutput logger = parameters.getStyledTextOutputFactory().create(ReportPublication.class);
        TreeMap<ReportPublication.Repository, TreeSet<ReportPublication>> publications = new TreeMap<ReportPublication.Repository, TreeSet<ReportPublication>>(new Comparator(){

            public final int compare(T a, T b) {
                ReportPublication.Repository p0 = (ReportPublication.Repository)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getValue());
                p0 = (ReportPublication.Repository)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getValue())));
            }
        });
        Map outcomes = (Map)parameters.getOutcomes().get();
        Object object = parameters.getPublications().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map $this$forEach$iv = (Map)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String path = (String)entry.getKey();
            ReportPublication pub = (ReportPublication)entry.getValue();
            ReportPublication.Outcome outcome = (ReportPublication.Outcome)((Object)outcomes.get(path));
            if (outcome == null) {
                outcome = pub.getOutcome();
            }
            ReportPublication.Outcome outcome2 = outcome;
            publications.compute(pub.getRepository(), (arg_0, arg_1) -> ReportPublicationsFlowAction.execute$lambda$1$lambda$0((Function2)new Function2<ReportPublication.Repository, TreeSet<ReportPublication>, TreeSet<ReportPublication>>(this, pub, outcome2){
                final /* synthetic */ ReportPublicationsFlowAction this$0;
                final /* synthetic */ ReportPublication $pub;
                final /* synthetic */ ReportPublication.Outcome $outcome;
                {
                    this.this$0 = $receiver;
                    this.$pub = $pub;
                    this.$outcome = $outcome;
                    super(2);
                }

                @Nullable
                public final TreeSet<ReportPublication> invoke(@NotNull ReportPublication.Repository repository, @Nullable TreeSet<ReportPublication> set) {
                    Intrinsics.checkNotNullParameter((Object)repository, (String)"<anonymous parameter 0>");
                    TreeSet<ReportPublication> treeSet = set;
                    if (treeSet == null) {
                        treeSet = new TreeSet<ReportPublication>(ReportPublicationsFlowAction.access$getPublicationsComparator$p(this.this$0));
                    }
                    TreeSet<ReportPublication> treeSet2 = treeSet;
                    ReportPublication reportPublication = this.$pub;
                    ReportPublication.Outcome outcome = this.$outcome;
                    TreeSet<ReportPublication> $this$invoke_u24lambda_u240 = treeSet2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)reportPublication);
                    $this$invoke_u24lambda_u240.add(ReportPublication.copy$default(reportPublication, null, null, null, null, outcome, null, 47, null));
                    return treeSet2;
                }
            }, arg_0, arg_1));
        }
        Intrinsics.checkNotNull((Object)logger);
        this.report(logger, publications);
    }

    private final void report(StyledTextOutput $this$report, TreeMap<ReportPublication.Repository, TreeSet<ReportPublication>> publications) {
        StyledTextOutput header = $this$report.withStyle(StyledTextOutput.Style.Header);
        StyledTextOutput description = $this$report.withStyle(StyledTextOutput.Style.Description);
        StyledTextOutput identifier = $this$report.withStyle(StyledTextOutput.Style.Identifier);
        StyledTextOutput info = $this$report.withStyle(StyledTextOutput.Style.Info);
        StyledTextOutput failure = $this$report.withStyle(StyledTextOutput.Style.Failure);
        StyledTextOutput failureHeader = $this$report.withStyle(StyledTextOutput.Style.FailureHeader);
        $this$report.println();
        Map $this$forEach$iv = publications;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ReportPublication.Repository repository = (ReportPublication.Repository)entry.getKey();
            TreeSet publications2 = (TreeSet)entry.getValue();
            $this$report.text((Object)"The following artifacts were published to ");
            header.text((Object)repository.getName());
            if (!StringsKt.isBlank((CharSequence)repository.getValue())) {
                $this$report.text((Object)"(");
                description.text((Object)repository.getValue());
                $this$report.text((Object)")");
            }
            $this$report.println((Object)":");
            Iterable $this$forEach$iv2 = publications2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ReportPublication it = (ReportPublication)element$iv2;
                boolean bl2 = false;
                $this$report.text((Object)" - ");
                identifier.text((Object)it.getGroupId());
                $this$report.text((Object)(":" + it.getArtifactId() + ":"));
                info.text((Object)it.getVersion());
                failure.text((Object)CollectionsKt.joinToString$default((Iterable)it.getArtifacts(), (CharSequence)", ", (CharSequence)" [", (CharSequence)"]", (int)0, null, null, (int)56, null));
                if (it.getOutcome() != ReportPublication.Outcome.Published) {
                    String string = it.getOutcome().name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    failureHeader.text((Object)(" (" + string + ")"));
                }
                $this$report.println();
            }
        }
    }

    private static final TreeSet execute$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TreeSet)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Comparator access$getPublicationsComparator$p(ReportPublicationsFlowAction $this) {
        return $this.publicationsComparator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/gmazzo/publications/report/ReportPublicationsFlowAction$Params;", "Lorg/gradle/api/flow/FlowParameters;", "outcomes", "Lorg/gradle/api/provider/MapProperty;", "", "Lio/github/gmazzo/publications/report/ReportPublication$Outcome;", "getOutcomes", "()Lorg/gradle/api/provider/MapProperty;", "publications", "Lio/github/gmazzo/publications/report/ReportPublication;", "getPublications", "styledTextOutputFactory", "Lorg/gradle/internal/logging/text/StyledTextOutputFactory;", "getStyledTextOutputFactory", "()Lorg/gradle/internal/logging/text/StyledTextOutputFactory;", "plugin"})
    public static interface Params
    extends FlowParameters {
        @Inject
        @NotNull
        public StyledTextOutputFactory getStyledTextOutputFactory();

        @Input
        @NotNull
        public MapProperty<String, ReportPublication> getPublications();

        @Input
        @NotNull
        public MapProperty<String, ReportPublication.Outcome> getOutcomes();
    }
}

