/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.chibde.BaseVisualizer;
import java.util.HashMap;
import java.util.Map;

public class CircleBarVisualizerSmooth
extends BaseVisualizer {
    private static final float _StepsCount = 2.0f;
    private static final int _BarCount = 120;
    private static final float _AngleStep = 3.0f;
    private float[] points;
    private float[] endPoints;
    private float[] diffs;
    private Map<String, Integer> configs = null;

    public CircleBarVisualizerSmooth(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        this.paint.setStyle(Paint.Style.STROKE);
    }

    private int getConfig(String key) {
        Integer obj = this.configs.get(key);
        if (obj != null) {
            return obj;
        }
        return 0;
    }

    private void setConfig(String key, int value) {
        this.configs.put(key, value);
    }

    private int getSmallerDimen() {
        if (this.getHeight() < this.getWidth()) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    private void fillConfigs() {
        if (this.configs != null) {
            return;
        }
        this.configs = new HashMap<String, Integer>();
        int radius = (int)((double)this.getSmallerDimen() * 0.65 / 2.0) * 6 / 10;
        double circumference = 4.71238898038469 * (double)radius;
        this.paint.setStrokeWidth((float)(circumference / 120.0));
        this.configs.put("needsInit", 1);
        this.configs.put("radius", radius);
        this.configs.put("stepCounter", 0);
    }

    private void initPoints() {
        if (this.getConfig("needsInit") == 1 || this.points == null || this.points.length < this.bytes.length * 2) {
            this.points = new float[this.bytes.length * 4];
            this.endPoints = new float[this.bytes.length * 4];
            this.diffs = new float[this.bytes.length * 2];
        }
    }

    private void fillPoints(int round, int i) {
        int indexM2 = i * 2;
        int indexM4 = i * 4;
        if ((float)round <= 2.0f) {
            this.points[indexM4 + 2] = this.endPoints[indexM4 + 2] + this.diffs[indexM2] * (float)round;
            this.points[indexM4 + 3] = this.endPoints[indexM4 + 3] + this.diffs[indexM2 + 1] * (float)round;
        }
    }

    private void fillEndPointsAndDiffs(int i, float newX, float newY) {
        this.endPoints[i * 4 + 2] = this.endPoints[i * 4];
        this.endPoints[i * 4 + 3] = this.endPoints[i * 4 + 1];
        this.endPoints[i * 4] = newX;
        this.endPoints[i * 4 + 1] = newY;
        if (this.getConfig("needsInit") == 0) {
            this.diffs[i * 2] = (this.endPoints[i * 4] - this.endPoints[i * 4 + 2]) / 2.0f;
            this.diffs[i * 2 + 1] = (this.endPoints[i * 4 + 1] - this.endPoints[i * 4 + 3]) / 2.0f;
        } else {
            this.endPoints[i * 4 + 2] = this.endPoints[i * 4];
            this.endPoints[i * 4 + 3] = this.endPoints[i * 4 + 1];
        }
    }

    private void calcRound(int i, double angle) {
        int t = this.getBarLength(i, ((float)this.bytes.length - (float)this.bytes.length % 4.0f) / 120.0f);
        int round = (int)((float)this.getConfig("stepCounter") % 2.0f);
        if (round == 0) {
            float radius_p_t = this.getConfig("radius") + t;
            this.fillEndPointsAndDiffs(i, (float)((double)(this.getWidth() / 2) + (double)radius_p_t * Math.cos(angle)), (float)((double)(this.getHeight() / 2) + (double)radius_p_t * Math.sin(angle)));
        }
        this.fillPoints(round, i);
    }

    private int getBarLength(int i, float ceiling) {
        int x = (int)Math.ceil((float)i * ceiling);
        byte a = (byte)(-Math.abs(this.bytes[x]) + 128);
        return a * (this.getHeight() / 4) / 128;
    }

    private void fillStartingPoints(int i, double angle) {
        int indexM4 = i * 4;
        if (this.getConfig("needsInit") == 1) {
            this.points[indexM4] = (float)((double)(this.getWidth() / 2) + (double)this.getConfig("radius") * Math.cos(angle));
            this.points[indexM4 + 1] = (float)((double)(this.getHeight() / 2) + (double)this.getConfig("radius") * Math.sin(angle));
        }
        this.calcRound(i, angle);
    }

    protected void onDraw(Canvas canvas) {
        if (this.bytes == null) {
            return;
        }
        this.fillConfigs();
        this.initPoints();
        double angle = 0.0;
        int i = 0;
        while (i < 120) {
            double radianAngle = Math.toRadians(angle);
            this.fillStartingPoints(i, radianAngle);
            ++i;
            angle += 3.0;
        }
        if (this.getConfig("needsInit") == 0) {
            canvas.drawLines(this.points, this.paint);
        }
        super.onDraw(canvas);
        this.resetConfigs();
    }

    private void resetConfigs() {
        this.setConfig("stepCounter", this.getConfig("stepCounter") + 1);
        if (this.getConfig("needsInit") == 1) {
            this.setConfig("needsInit", 0);
        }
    }
}

