/*
 * Decompiled with CFR 0.152.
 */
package com.chibde.visualizer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.chibde.BaseVisualizer;

class BlazingColorVisualizer
extends BaseVisualizer {
    private Shader shader;

    public BlazingColorVisualizer(Context context) {
        super(context);
    }

    public BlazingColorVisualizer(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BlazingColorVisualizer(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.shader = new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getHeight(), -16776961, -16711936, Shader.TileMode.MIRROR);
    }

    protected void onDraw(Canvas canvas) {
        if (this.bytes != null) {
            this.paint.setShader(this.shader);
            int i = 0;
            for (int k = 0; i < this.bytes.length - 1 && k < this.bytes.length; ++i, ++k) {
                int top = this.getHeight() + (byte)(Math.abs(this.bytes[k]) + 128) * this.getHeight() / 128;
                canvas.drawLine((float)i, (float)this.getHeight(), (float)i, (float)top, this.paint);
            }
            super.onDraw(canvas);
        }
    }
}

