/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.utils;

import com.g42cloud.sdk.core.utils.StringUtils;
import java.io.File;
import java.io.IOException;

public class PathUtils {
    public static boolean isPathExist(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        return new File(path).exists();
    }

    public static boolean isValidFile(String path) {
        if (StringUtils.isEmpty(path)) {
            return false;
        }
        return PathUtils.isValidFile(new File(path));
    }

    public static boolean isValidFile(File file) {
        if (!file.exists()) {
            return false;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists() || !parentFile.isDirectory()) {
            return false;
        }
        try {
            if (!file.getCanonicalFile().toPath().startsWith(parentFile.getCanonicalFile().toPath())) {
                return false;
            }
        }
        catch (IOException ignore) {
            return false;
        }
        return true;
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }
}

