/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.g42cloud.sdk.core.http.FormDataFilePart;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.NoSuchFileException;

public class FormDataDeserializer
extends JsonDeserializer<FormDataFilePart> {
    public FormDataFilePart deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            File file = new File(jsonParser.getValueAsString());
            if (file.exists()) {
                return new FormDataFilePart(new FileInputStream(file), file.getName());
            }
            throw new NoSuchFileException(file.getPath() + " not exists.");
        }
        throw new JsonParseException(jsonParser, String.format("Current token (%s) not of string type", jsonParser.getCurrentToken()));
    }
}

