/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.impl;

import com.g42cloud.sdk.core.HttpListener;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.exchange.ApiTimer;
import com.g42cloud.sdk.core.exchange.SdkExchange;
import com.g42cloud.sdk.core.exchange.SdkExchangeCache;
import com.g42cloud.sdk.core.http.HttpConfig;
import com.g42cloud.sdk.core.impl.DefaultHttpUtils;
import com.g42cloud.sdk.core.utils.HttpUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

public class DefaultHttpListener
implements Interceptor {
    private final List<HttpListener> httpListeners;

    public DefaultHttpListener(HttpConfig httpConfig) {
        this.httpListeners = httpConfig.getHttpListeners();
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        SdkExchange exchange = SdkExchangeCache.getExchange(request.header("SDK_EXCHANGE"));
        exchange = Objects.isNull(exchange) ? new SdkExchange() : exchange;
        request = request.newBuilder().removeHeader("SDK_EXCHANGE").build();
        exchange.withApiTimer(ApiTimer::start);
        if (Objects.nonNull(this.httpListeners)) {
            this.preRequest(request, exchange);
        }
        Response response = chain.proceed(request.newBuilder().removeHeader("SDK_EXCHANGE").build());
        exchange.withApiTimer(ApiTimer::end);
        if (Objects.nonNull(this.httpListeners)) {
            return this.postResponse(response, exchange);
        }
        return response;
    }

    public void preRequest(final Request request, final SdkExchange sdkExchange) throws IOException {
        String reqBody = null;
        RequestBody body = request.body();
        if (Objects.nonNull(body)) {
            String contentType = Optional.of(body).map(RequestBody::contentType).map(MediaType::toString).orElse("");
            if (HttpUtils.isTextBasedContentType(contentType)) {
                Buffer buffer = new Buffer();
                body.writeTo((BufferedSink)buffer);
                reqBody = buffer.readUtf8();
            } else if (HttpUtils.isOctetStreamContentType(contentType)) {
                reqBody = body.contentLength() > 0L || body.contentLength() == -1L ? "******" : null;
            }
        }
        final String finalReqBody = reqBody;
        HttpListener.RequestListener requestListener = new HttpListener.RequestListener(){

            @Override
            public String httpMethod() {
                return request.method();
            }

            @Override
            public String uri() {
                return request.url().toString();
            }

            @Override
            public Map<String, List<String>> headers() {
                return DefaultHttpUtils.headersToMap(request.headers());
            }

            @Override
            public Optional<String> body() {
                return Optional.ofNullable(finalReqBody);
            }

            @Override
            public SdkExchange exchange() {
                return sdkExchange;
            }
        };
        this.httpListeners.forEach(httpListener -> httpListener.preRequest(requestListener));
    }

    public Response postResponse(final Response response, final SdkExchange sdkExchange) throws IOException {
        final Request request = response.request();
        Response.Builder responseBuilder = response.newBuilder();
        String respBody = null;
        ResponseBody body = response.body();
        if (Objects.nonNull(body)) {
            if (body.contentLength() == 0L) {
                respBody = body.string();
                responseBuilder.body(this.createResponseBody(respBody, body.contentType()));
            } else {
                String contentType = Optional.of(body).map(ResponseBody::contentType).map(MediaType::toString).orElseThrow(() -> new SdkException("Failed to parse the Content-Type of ResponseBody"));
                if (HttpUtils.isTextBasedContentType(contentType)) {
                    respBody = body.string();
                    responseBuilder.body(this.createResponseBody(respBody, body.contentType()));
                } else if (HttpUtils.isOctetStreamContentType(contentType)) {
                    respBody = body.contentLength() > 0L || body.contentLength() == -1L ? "******" : null;
                }
            }
        }
        final String finalRespBody = respBody;
        HttpListener.ResponseListener responseListener = new HttpListener.ResponseListener(){

            @Override
            public String httpMethod() {
                return request.method();
            }

            @Override
            public String uri() {
                return request.url().toString();
            }

            @Override
            public Map<String, List<String>> headers() {
                return DefaultHttpUtils.headersToMap(response.headers());
            }

            @Override
            public Optional<String> body() {
                return Optional.ofNullable(finalRespBody);
            }

            @Override
            public int statusCode() {
                return response.code();
            }

            @Override
            public SdkExchange exchange() {
                return sdkExchange;
            }
        };
        this.httpListeners.forEach(httpListener -> httpListener.postResponse(responseListener));
        return responseBuilder.build();
    }

    private ResponseBody createResponseBody(String content, MediaType contentType) {
        try {
            return ResponseBody.create((String)content, (MediaType)contentType);
        }
        catch (NoSuchMethodError e) {
            return ResponseBody.create((MediaType)contentType, (String)content);
        }
    }
}

