/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.impl;

import com.g42cloud.sdk.core.exception.ConnectionException;
import com.g42cloud.sdk.core.exception.HostUnreachableException;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.exception.SslHandShakeException;
import com.g42cloud.sdk.core.http.FormDataFilePart;
import com.g42cloud.sdk.core.http.HttpClient;
import com.g42cloud.sdk.core.http.HttpConfig;
import com.g42cloud.sdk.core.http.HttpRequest;
import com.g42cloud.sdk.core.http.HttpResponse;
import com.g42cloud.sdk.core.impl.DefaultHttpListener;
import com.g42cloud.sdk.core.impl.DefaultHttpResponse;
import com.g42cloud.sdk.core.progress.ProgressInputStream;
import com.g42cloud.sdk.core.progress.RepeatableRequestEntity;
import com.g42cloud.sdk.core.progress.SimpleProgressManager;
import com.g42cloud.sdk.core.ssl.IgnoreSSLVerificationFactory;
import com.g42cloud.sdk.core.utils.ExceptionUtils;
import com.g42cloud.sdk.core.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final String OKHTTP_PREEMPTIVE = "OkHttp-Preemptive";
    private static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private static final int DEFAULT_READ_TIMEOUT = 120;
    private OkHttpClient client;
    private HttpConfig httpConfig;

    public DefaultHttpClient(HttpConfig httpConfig) {
        this.withHttpConfig(httpConfig);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public DefaultHttpClient withHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(httpConfig.isAllowRedirects());
        clientBuilder.connectionPool(httpConfig.getConnectionPool());
        if (Objects.nonNull(httpConfig.getDispatcher())) {
            clientBuilder.dispatcher(httpConfig.getDispatcher());
        }
        clientBuilder.connectTimeout((long)httpConfig.getTimeout(), TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS);
        if (Objects.nonNull(httpConfig.getSSLSocketFactory()) && Objects.nonNull(httpConfig.getX509TrustManager())) {
            clientBuilder.sslSocketFactory(httpConfig.getSSLSocketFactory(), httpConfig.getX509TrustManager());
        }
        if (httpConfig.isIgnoreSSLVerification()) {
            clientBuilder.hostnameVerifier(IgnoreSSLVerificationFactory.getHostnameVerifier()).sslSocketFactory(IgnoreSSLVerificationFactory.getSSLContext(httpConfig.getSecureRandom()).getSocketFactory(), IgnoreSSLVerificationFactory.getTrustAllManager());
        }
        clientBuilder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        if (!StringUtils.isEmpty(httpConfig.getProxyHost())) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpConfig.getProxyHost(), httpConfig.getProxyPort()));
            clientBuilder.proxy(proxy);
        }
        if (!StringUtils.isEmpty(httpConfig.getProxyUsername())) {
            Authenticator proxyAuthenticator = (route, response) -> {
                if (!OKHTTP_PREEMPTIVE.equals(response.header(PROXY_AUTHENTICATE)) && response.code() == 407) {
                    return null;
                }
                String credential = Credentials.basic((String)httpConfig.getProxyUsername(), (String)httpConfig.getProxyPassword());
                return response.request().newBuilder().header(PROXY_AUTHORIZATION, credential).build();
            };
            clientBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.client = clientBuilder.addInterceptor((Interceptor)new DefaultHttpListener(httpConfig)).build();
        return this;
    }

    private Request buildOkHttpRequest(HttpRequest httpRequest) {
        Request.Builder requestBuilder = new Request.Builder();
        String url = httpRequest.getEndpoint() + httpRequest.getPathParamsString();
        HttpUrl httpUrl = Optional.ofNullable(HttpUrl.parse((String)url)).orElseThrow(() -> new SdkException("failed to parse url from " + url));
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        httpRequest.getQueryParams().forEach((key, values) -> {
            if (values.size() == 0) {
                urlBuilder.addQueryParameter(key, null);
            } else {
                values.forEach(value -> urlBuilder.addQueryParameter(key, value));
            }
        });
        requestBuilder.url(urlBuilder.build());
        httpRequest.getHeaders().forEach((key, values) -> values.forEach(value -> requestBuilder.header(key, value)));
        if (Objects.isNull(httpRequest.getBodyAsString())) {
            return httpRequest.getContentType().startsWith("multipart/form-data") ? this.buildOkHttpRequestWithFormData(httpRequest, requestBuilder) : this.buildOkHttpRequestWithoutTextBody(httpRequest, requestBuilder);
        }
        return this.buildOkHttpRequestWithTextBody(httpRequest, requestBuilder);
    }

    private Request buildOkHttpRequestWithFormData(HttpRequest httpRequest, Request.Builder requestBuilder) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        MediaType mediaType = Optional.ofNullable(MediaType.parse((String)httpRequest.getContentType())).orElseThrow(() -> new SdkException("failed to parse request Content-Type from " + httpRequest.getContentType()));
        bodyBuilder.setType(mediaType);
        httpRequest.getFormData().forEach((name, part) -> {
            if (part instanceof FormDataFilePart) {
                final FormDataFilePart filePart = (FormDataFilePart)part;
                bodyBuilder.addFormDataPart(name, filePart.getFilename(), new RequestBody(){

                    public MediaType contentType() {
                        return Objects.isNull(filePart.getContentType()) ? null : MediaType.parse((String)filePart.getContentType());
                    }

                    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                        try (Source source = Okio.source((InputStream)filePart.getInputStream());){
                            bufferedSink.writeAll(source);
                        }
                    }
                });
            } else {
                bodyBuilder.addFormDataPart(name, part.toString());
            }
        });
        requestBuilder.method(httpRequest.getMethod().toString(), (RequestBody)bodyBuilder.build());
        return requestBuilder.build();
    }

    private Request buildOkHttpRequestWithTextBody(final HttpRequest httpRequest, Request.Builder requestBuilder) {
        requestBuilder.method(httpRequest.getMethod().toString(), new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)httpRequest.getContentType());
            }

            public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                bufferedSink.writeUtf8(httpRequest.getBodyAsString());
            }

            public long contentLength() throws IOException {
                if (httpRequest.haveHeader("Content-Length").booleanValue()) {
                    return Long.parseLong(httpRequest.getHeader("Content-Length"));
                }
                return super.contentLength();
            }
        });
        return requestBuilder.build();
    }

    private Request buildOkHttpRequestWithoutTextBody(HttpRequest httpRequest, Request.Builder requestBuilder) {
        if (Objects.isNull(httpRequest.getBody())) {
            if (HttpMethod.requiresRequestBody((String)httpRequest.getMethod().toString())) {
                requestBuilder.method(httpRequest.getMethod().toString(), this.createRequestBody(new byte[0], null));
            } else {
                requestBuilder.method(httpRequest.getMethod().toString(), null);
            }
        } else {
            this.buildStreamRequestBody(httpRequest, requestBuilder);
        }
        return requestBuilder.build();
    }

    private RequestBody createRequestBody(byte[] content, MediaType contentType) {
        try {
            return RequestBody.create((byte[])content, (MediaType)contentType);
        }
        catch (NoSuchMethodError e) {
            return RequestBody.create((MediaType)contentType, (byte[])content);
        }
    }

    private void buildStreamRequestBody(final HttpRequest httpRequest, Request.Builder requestBuilder) {
        RequestBody requestBody;
        if (Objects.isNull(httpRequest.getProgressListener())) {
            requestBody = new RequestBody(){

                public MediaType contentType() {
                    return MediaType.parse((String)httpRequest.getContentType());
                }

                public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                    try (Source source = Okio.source((InputStream)httpRequest.getBody());){
                        bufferedSink.writeAll(source);
                    }
                }
            };
        } else {
            long contentLength;
            try {
                contentLength = httpRequest.haveHeader("Content-Length") != false ? Long.parseLong(httpRequest.getHeader("Content-Length")) : (long)httpRequest.getBody().available();
            }
            catch (IOException | NumberFormatException ignore) {
                contentLength = -1L;
            }
            SimpleProgressManager progressManager = new SimpleProgressManager(contentLength, 0L, httpRequest.getProgressListener(), httpRequest.getProgressInterval());
            ProgressInputStream inputStream = new ProgressInputStream(httpRequest.getBody(), progressManager);
            requestBody = new RepeatableRequestEntity(inputStream, httpRequest.getHeader("Content-Type"), contentLength);
        }
        requestBuilder.method(httpRequest.getMethod().toString(), requestBody);
    }

    public Callback toCallback(final CompletableFuture<Response> future) {
        return new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                future.complete(response);
            }
        };
    }

    @Override
    public CompletableFuture<HttpResponse> asyncInvokeHttp(HttpRequest httpRequest) {
        Request request = this.buildOkHttpRequest(httpRequest);
        CompletableFuture<Response> asyncHttpResponse = new CompletableFuture<Response>();
        this.client.newCall(request).enqueue(this.toCallback(asyncHttpResponse));
        return asyncHttpResponse.handleAsync((response, throwable) -> {
            if (Objects.nonNull(request.body()) && request.body() instanceof Closeable) {
                this.closeStream((Closeable)request.body());
            }
            if (throwable != null) {
                if (throwable instanceof SSLHandshakeException) {
                    logger.error("DefaultHttpClient SslHandShakeException", throwable);
                    throw new SslHandShakeException("DefaultHttpClient SslHandShakeException", (Throwable)throwable);
                }
                if (throwable instanceof UnknownHostException) {
                    logger.error("DefaultHttpClient HostUnreachableException", throwable);
                    throw new HostUnreachableException("DefaultHttpClient HostUnreachableException", (Throwable)throwable);
                }
                if (throwable instanceof SocketTimeoutException) {
                    logger.error("DefaultHttpClient RequestTimeoutException", throwable);
                    ExceptionUtils.mapSocketTimeoutException("DefaultHttpClient RequestTimeoutException", throwable);
                } else {
                    logger.error("DefaultHttpClient ConnectionException", throwable);
                    throw new ConnectionException("DefaultHttpClient ConnectionException", (Throwable)throwable);
                }
            }
            return DefaultHttpResponse.wrap(response);
        }, (Executor)this.httpConfig.getExecutorService());
    }

    @Override
    public HttpResponse syncInvokeHttp(HttpRequest httpRequest) throws ConnectionException {
        Request request = this.buildOkHttpRequest(httpRequest);
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (SSLHandshakeException e) {
            logger.error("DefaultHttpClient SslHandShakeException", (Throwable)e);
            throw new SslHandShakeException("DefaultHttpClient SslHandShakeException", e);
        }
        catch (UnknownHostException e) {
            logger.error("DefaultHttpClient HostUnreachableException", (Throwable)e);
            throw new HostUnreachableException("DefaultHttpClient HostUnreachableException", e);
        }
        catch (SocketTimeoutException e) {
            logger.error("DefaultHttpClient RequestTimeout", (Throwable)e);
            ExceptionUtils.mapSocketTimeoutException("DefaultHttpClient RequestTimeout", e);
        }
        catch (IOException e) {
            logger.error("DefaultHttpClient ConnectionException", (Throwable)e);
            throw new ConnectionException("DefaultHttpClient ConnectionException", e);
        }
        finally {
            if (Objects.nonNull(request.body()) && request.body() instanceof Closeable) {
                this.closeStream((Closeable)request.body());
            }
        }
        return DefaultHttpResponse.wrap(response);
    }

    private void closeStream(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.warn("close failed.", (Throwable)e);
        }
    }
}

