/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.http;

import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.http.Field;
import com.g42cloud.sdk.core.http.FieldExistence;
import com.g42cloud.sdk.core.http.LocationType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FieldImpl<R, F>
implements Field<R, F> {
    String name;
    LocationType locationType;
    FieldExistence existence;
    Class<F> fieldType;
    Class<?> innerContainerType;
    Function<R, F> reader;
    BiConsumer<R, F> writer;
    Function<R, Boolean> isValueProvidedFunc;

    public FieldImpl(String name, LocationType locationType, FieldExistence existence, Class<F> fieldType) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.locationType = Objects.requireNonNull(locationType, "locationType cannot be null");
        this.existence = Objects.requireNonNull(existence, "existence cannot be null");
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType cannot be null");
        this.isValueProvidedFunc = null;
        this.reader = null;
        this.writer = null;
    }

    public <T> FieldImpl<R, F> withInnerContainerType(Class<T> innerContainerType) {
        this.innerContainerType = innerContainerType;
        return this;
    }

    public FieldImpl<R, F> withReader(Function<R, F> valueReader) {
        Objects.requireNonNull(valueReader, "valueReader cannot be null");
        this.reader = valueReader;
        return this;
    }

    public FieldImpl<R, F> withWriter(BiConsumer<R, F> writer) {
        this.writer = writer;
        return this;
    }

    public FieldImpl<R, F> withValueProvideTest(Function<R, Boolean> valuePresenceTester) {
        this.isValueProvidedFunc = valuePresenceTester;
        return this;
    }

    public FieldImpl<R, F> withMarshaller(Function<R, F> valueReader, BiConsumer<R, F> writer) {
        return this.withReader(valueReader).withWriter(writer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocationType getLocation() {
        return this.locationType;
    }

    @Override
    public FieldExistence getExistence() {
        return this.existence;
    }

    @Override
    public Class<F> getFieldType() {
        return this.fieldType;
    }

    @Override
    public Class<?> getInnerContainerType() {
        return this.innerContainerType;
    }

    @Override
    public Optional<F> readValue(R request) {
        F value = this.reader.apply(request);
        if (value == null) {
            if (this.existence == FieldExistence.NULL_IGNORE) {
                return Optional.empty();
            }
            throw new SdkException("request field " + this.name + " read null value. existence is: " + this.existence.toString());
        }
        if (this.existence == FieldExistence.NON_NULL_NON_EMPTY && value.getClass() == String.class && ((String)value).isEmpty()) {
            throw new SdkException("request field " + this.name + " read empty value. not allowed by " + (Object)((Object)this.existence));
        }
        return Optional.of(value);
    }

    @Override
    public Optional<F> readValueNoValidation(R request) {
        F value = this.reader.apply(request);
        return value == null ? Optional.empty() : Optional.of(value);
    }

    @Override
    public void writeValue(R request, F value, Class<F> clazz) {
        this.writeValueSafe(request, value, clazz);
    }

    @Override
    public void writeValueSafe(R request, Object value, Class<?> clazz) {
        if (this.fieldType.isAssignableFrom(clazz)) {
            this.writer.accept(request, value);
        } else {
            F enumValue = this.tryFindEnumField(value, clazz).orElseThrow(() -> new SdkException("input value " + value + " with class " + clazz.getSimpleName() + " is not compatible with expected class " + this.fieldType.getSimpleName()));
            this.writer.accept(request, enumValue);
        }
    }

    @Override
    public boolean isValueProvided(R request) {
        if (this.isValueProvidedFunc != null) {
            return this.isValueProvidedFunc.apply(request);
        }
        throw new SdkException("isValueProvided bad call");
    }

    private <T> Optional<F> tryFindEnumField(Object value, Class<T> clazz) {
        if (!this.fieldType.isEnum() || !clazz.isAssignableFrom(String.class)) {
            return Optional.empty();
        }
        F[] enumValues = this.fieldType.getEnumConstants();
        if (enumValues == null) {
            return Optional.empty();
        }
        for (F enumValue : enumValues) {
            if (!enumValue.toString().equals(value)) continue;
            return Optional.of(enumValue);
        }
        return Optional.empty();
    }
}

