/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.HcClient;
import com.g42cloud.sdk.core.auth.AKSKSignerFactory;
import com.g42cloud.sdk.core.auth.AbstractCredentials;
import com.g42cloud.sdk.core.auth.AuthCache;
import com.g42cloud.sdk.core.auth.DerivedAKSKSigner;
import com.g42cloud.sdk.core.auth.IAKSKSigner;
import com.g42cloud.sdk.core.auth.ICredential;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.http.HttpClient;
import com.g42cloud.sdk.core.http.HttpRequest;
import com.g42cloud.sdk.core.internal.Iam;
import com.g42cloud.sdk.core.internal.InnerIamMeta;
import com.g42cloud.sdk.core.internal.model.CreateTokenWithIdTokenResponse;
import com.g42cloud.sdk.core.internal.model.KeystoneListAuthDomainsRequest;
import com.g42cloud.sdk.core.internal.model.KeystoneListAuthDomainsResponse;
import com.g42cloud.sdk.core.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalCredentials
extends AbstractCredentials<GlobalCredentials> {
    private String domainId;

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public GlobalCredentials withDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    Map<String, Object> getPathParams() {
        LinkedHashMap<String, Object> pathParam = new LinkedHashMap<String, Object>();
        if (Objects.nonNull(this.domainId)) {
            pathParam.put("domain_id", this.domainId);
        }
        return pathParam;
    }

    @Override
    public CompletableFuture<ICredential> processAuthParams(HcClient hcClient, String regionId) {
        return CompletableFuture.supplyAsync(() -> {
            if (!StringUtils.isEmpty(this.getIdpId()) || !StringUtils.isEmpty(this.getIdTokenFile())) {
                if (StringUtils.isEmpty(this.getIdpId())) {
                    throw new SdkException("idpId is required when using idpId&idTokenFile");
                }
                if (StringUtils.isEmpty(this.getIdTokenFile())) {
                    throw new SdkException("idTokenFile is required when using idpId&idTokenFile");
                }
                if (StringUtils.isEmpty(this.domainId)) {
                    throw new SdkException("domainId is required when using idpId&idTokenFile");
                }
            }
            if (!StringUtils.isEmpty(this.domainId)) {
                return this;
            }
            String akWithName = this.getAk();
            if (Objects.nonNull(AuthCache.getAuth(akWithName)) && !StringUtils.isEmpty(AuthCache.getAuth(akWithName))) {
                this.domainId = AuthCache.getAuth(akWithName);
                return this;
            }
            String iamEndpoint = this.getUsedIamEndpoint();
            HcClient inner = hcClient.overrideEndpoints(Collections.singletonList(iamEndpoint));
            Function<HttpRequest, Boolean> derivedPredicate = this.getDerivedPredicate();
            this.setDerivedPredicate(null);
            Logger logger = LoggerFactory.getLogger(hcClient.getClass());
            logger.info("domain id not found in BasicCredentials, trying to obtain domain id from IAM service: " + iamEndpoint);
            KeystoneListAuthDomainsRequest request = new KeystoneListAuthDomainsRequest();
            KeystoneListAuthDomainsResponse response = inner.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_AUTH_DOMAINS);
            if (Objects.isNull(response) || Objects.isNull(response.getDomains()) || response.getDomains().size() == 0) {
                throw new SdkException("no domain id found, please select one of the following solutions:\n  1. Manually specify domainId when initializing the credentials, GlobalCredentials cred = new GlobalCredentials().withAk(ak).withSk(sk).withDomainId(domainId)\n  2. Use the domain account to grant IAM read permission to the current account\n  3. Replace the ak/sk of the IAM account with the ak/sk of the domain account");
            }
            this.domainId = response.getDomains().get(0).getId();
            logger.info("success to obtain domain id: " + this.domainId);
            AuthCache.putAuth(akWithName, this.domainId);
            this.setDerivedPredicate(derivedPredicate);
            return this;
        }, hcClient.getHttpConfig().getExecutorService());
    }

    @Override
    public CompletableFuture<HttpRequest> processAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        return CompletableFuture.completedFuture(this.syncProcessAuthRequest(httpRequest, httpClient));
    }

    @Override
    public HttpRequest syncProcessAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        Map<String, String> headers;
        HttpRequest.HttpRequestBuilder builder = httpRequest.builder().addAutoFilledPathParam(this.getPathParams());
        if (this.needUpdateAuthToken()) {
            this.updateAuthTokenByIdToken(httpClient);
        } else if (this.needUpdateSecurityToken()) {
            this.updateSecurityTokenFromMetadata();
        }
        if (Objects.nonNull(this.getDomainId())) {
            builder.addHeader("X-Domain-Id", this.getDomainId());
        }
        if (Objects.nonNull(this.authToken)) {
            builder.addHeader("X-Auth-Token", this.authToken);
            return builder.build();
        }
        if (Objects.nonNull(this.getSecurityToken())) {
            builder.addHeader("X-Security-Token", this.getSecurityToken());
        }
        if (Objects.nonNull(httpRequest.getContentType()) && !httpRequest.getContentType().startsWith("application/json")) {
            builder.addHeader("X-Sdk-Content-Sha256", "UNSIGNED-PAYLOAD");
        }
        if (this.isDerivedAuth(httpRequest)) {
            headers = DerivedAKSKSigner.getInstance().sign(builder.build(), this);
        } else {
            IAKSKSigner signer = AKSKSignerFactory.getSigner(httpRequest.getSigningAlgorithm());
            headers = signer.sign(builder.build(), this);
        }
        builder.addHeaders(headers);
        return builder.build();
    }

    @Override
    protected void updateAuthTokenByIdToken(HttpClient httpClient) {
        HttpRequest httpRequest = Iam.getDomainTokenWithIdTokenRequest(this.getUsedIamEndpoint(), this.getIdpId(), this.getIdToken(), this.domainId);
        CreateTokenWithIdTokenResponse response = Iam.createTokenWithIdToken(httpClient, httpRequest);
        this.authToken = response.getSubjectToken();
        try {
            String expiredTime = response.getToken().getExpiresAt().replace("000Z", "Z");
            this.expiredAt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(expiredTime).getTime();
        }
        catch (ParseException e) {
            throw new SdkException(e);
        }
    }

    @Override
    public void processDerivedAuthParams(String derivedAuthServiceName, String regionId) {
        if (this.derivedAuthServiceName == null) {
            this.derivedAuthServiceName = derivedAuthServiceName;
        }
        if (this.regionId == null) {
            this.regionId = "globe";
        }
    }

    @Override
    public GlobalCredentials deepClone() {
        GlobalCredentials credentials = (GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withDomainId(this.domainId).withAk(this.getAk())).withSk(this.getSk())).withIdpId(this.getIdpId())).withIdTokenFile(this.getIdTokenFile())).withDerivedPredicate(this.getDerivedPredicate())).withIamEndpoint(this.getIamEndpoint())).withSecurityToken(this.getSecurityToken());
        credentials.processDerivedAuthParams(this.derivedAuthServiceName, this.regionId);
        return credentials;
    }
}

