/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.auth.ICredential;
import com.g42cloud.sdk.core.exception.SdkException;
import com.g42cloud.sdk.core.http.HttpClient;
import com.g42cloud.sdk.core.http.HttpRequest;
import com.g42cloud.sdk.core.internal.Iam;
import com.g42cloud.sdk.core.internal.model.Credential;
import com.g42cloud.sdk.core.utils.StringUtils;
import com.g42cloud.sdk.core.utils.TimeUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractCredentials<T extends AbstractCredentials<T>>
implements ICredential {
    private String ak;
    private String sk;
    private String securityToken;
    private String idpId;
    private String idTokenFile;
    private String iamEndpoint;
    protected Long expiredAt;
    protected String authToken;
    protected String regionId;
    protected String derivedAuthServiceName;
    private Function<HttpRequest, Boolean> derivedPredicate;
    public static final Function<HttpRequest, Boolean> DEFAULT_DERIVED_PREDICATE = httpRequest -> !httpRequest.getEndpoint().replace("https://", "").matches("^[a-z][a-z0-9-]+(\\.[a-z]{2,}-[a-z]+-\\d{1,2})?\\.(my)?(g42cloud|myhwclouds).(com|cn)");

    public abstract void processDerivedAuthParams(String var1, String var2);

    public String getAk() {
        return this.ak;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public String getSk() {
        return this.sk;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public void setIdpId(String idpId) {
        this.idpId = idpId;
    }

    public String getIdTokenFile() {
        return this.idTokenFile;
    }

    public void setIdTokenFile(String idTokenFile) {
        this.idTokenFile = idTokenFile;
    }

    public String getIamEndpoint() {
        return this.iamEndpoint;
    }

    public void setIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
    }

    public Function<HttpRequest, Boolean> getDerivedPredicate() {
        return this.derivedPredicate;
    }

    public void setDerivedPredicate(Function<HttpRequest, Boolean> derivedPredicate) {
        this.derivedPredicate = derivedPredicate;
    }

    public T withAk(String ak) {
        this.ak = ak;
        return this.toDerivedT();
    }

    public T withSk(String sk) {
        this.sk = sk;
        return this.toDerivedT();
    }

    public T withSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        return this.toDerivedT();
    }

    public T withIdpId(String idpId) {
        this.idpId = idpId;
        return this.toDerivedT();
    }

    public T withIdTokenFile(String idTokenFile) {
        this.idTokenFile = idTokenFile;
        return this.toDerivedT();
    }

    public T withIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
        return this.toDerivedT();
    }

    public T withDerivedPredicate(Function<HttpRequest, Boolean> derivedPredicate) {
        this.derivedPredicate = derivedPredicate;
        return this.toDerivedT();
    }

    protected String getUsedIamEndpoint() {
        if (!StringUtils.isEmpty(this.iamEndpoint)) {
            return this.iamEndpoint;
        }
        String env = System.getenv("G42CLOUD_SDK_IAM_ENDPOINT");
        return StringUtils.isEmpty(env) ? "https://iam.ae-ad-1.g42cloud.com" : env;
    }

    protected boolean isDerivedAuth(HttpRequest httpRequest) {
        if (this.derivedPredicate == null) {
            return false;
        }
        return this.derivedPredicate.apply(httpRequest);
    }

    protected String getIdToken() {
        String idToken;
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(this.idTokenFile, new String[0]));
            idToken = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SdkException(e);
        }
        if (StringUtils.isEmpty(idToken)) {
            throw new SdkException(String.format("The content is empty in id token file '%s'", this.idTokenFile));
        }
        return idToken;
    }

    protected boolean needUpdateSecurityToken() {
        if (Objects.nonNull(this.authToken)) {
            return false;
        }
        if (Objects.isNull(this.ak) && Objects.isNull(this.sk)) {
            return true;
        }
        if (Objects.isNull(this.expiredAt) || Objects.isNull(this.securityToken)) {
            return false;
        }
        return this.expiredAt - TimeUtils.getTimeInMillis() < 60000L;
    }

    protected void updateSecurityTokenFromMetadata() {
        Credential credential = Iam.getCredentialFromMetadata();
        this.ak = credential.getAccess();
        this.sk = credential.getSecret();
        this.securityToken = credential.getSecurityToken();
        try {
            String expiredTime = credential.getExpiresAt().replace("000Z", "Z");
            this.expiredAt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(expiredTime).getTime();
        }
        catch (ParseException e) {
            throw new SdkException(e);
        }
    }

    protected boolean needUpdateAuthToken() {
        if (Objects.isNull(this.idpId) || Objects.isNull(this.idTokenFile)) {
            return false;
        }
        if (Objects.isNull(this.authToken) || Objects.isNull(this.expiredAt)) {
            return true;
        }
        return this.expiredAt - TimeUtils.getTimeInMillis() < 60000L;
    }

    private T toDerivedT() {
        return (T)this;
    }

    protected abstract void updateAuthTokenByIdToken(HttpClient var1);
}

