/*
 * Decompiled with CFR 0.152.
 */
package com.g42cloud.sdk.core.auth;

import com.g42cloud.sdk.core.auth.AKSKSigner;
import com.g42cloud.sdk.core.auth.IAKSKSigner;
import com.g42cloud.sdk.core.auth.P256SHA256Signer;
import com.g42cloud.sdk.core.auth.SM2SM3Signer;
import com.g42cloud.sdk.core.auth.SM3AKSKSigner;
import com.g42cloud.sdk.core.auth.SigningAlgorithm;
import com.g42cloud.sdk.core.exception.SdkException;

class AKSKSignerFactory {
    AKSKSignerFactory() {
    }

    static IAKSKSigner getSigner(SigningAlgorithm algorithm) {
        switch (algorithm) {
            case HMAC_SHA256: {
                return AKSKSigner.getInstance();
            }
            case HMAC_SM3: {
                return SM3AKSKSigner.getInstance();
            }
            case ECDSA_P256_SHA256: {
                return P256SHA256Signer.getInstance();
            }
            case SM2_SM3: {
                return SM2SM3Signer.getInstance();
            }
        }
        throw new SdkException("unsupported signing algorithm: " + (Object)((Object)algorithm));
    }
}

