package com.g42cloud.sdk.core.internal.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Credential {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "expires_at")

    private String expiresAt;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "access")

    private String access;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "secret")

    private String secret;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty(value = "securitytoken")

    private String securitytoken;

    public Credential withExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    public String getExpiresAt() {
        return expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Credential withAccess(String access) {
        this.access = access;
        return this;
    }

    public String getAccess() {
        return access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public Credential withSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Credential withSecuritytoken(String securitytoken) {
        this.securitytoken = securitytoken;
        return this;
    }

    public String getSecurityToken() {
        return securitytoken;
    }

    public void setSecurityToken(String securitytoken) {
        this.securitytoken = securitytoken;
    }
}
