/*
 * Decompiled with CFR 0.152.
 */
package com.funkatronics.encoders;

import com.funkatronics.encoders.error.InvalidInputException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ(\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/funkatronics/encoders/Base2N;", "", "()V", "PAD_CHAR", "", "decode", "", "alphabet", "", "base", "", "input", "encode", "pad", "", "gcd", "a", "b", "lcm", "MultiMult"})
@SourceDebugExtension(value={"SMAP\nBase2N.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base2N.kt\ncom/funkatronics/encoders/Base2N\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,94:1\n1855#2:95\n1856#2:97\n1855#2,2:98\n1#3:96\n1183#4,3:100\n*S KotlinDebug\n*F\n+ 1 Base2N.kt\ncom/funkatronics/encoders/Base2N\n*L\n33#1:95\n33#1:97\n42#1:98,2\n67#1:100,3\n*E\n"})
public final class Base2N {
    @NotNull
    public static final Base2N INSTANCE = new Base2N();
    public static final char PAD_CHAR = '=';

    private Base2N() {
    }

    @NotNull
    public final String encode(@NotNull String alphabet, int base, @NotNull byte[] input, boolean pad) {
        Intrinsics.checkNotNullParameter((Object)alphabet, (String)"alphabet");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if ((base & base - 1) != 0 || base == 0) {
            throw new InvalidInputException.InvalidBase("Provided base { " + base + " } is not a power of 2.");
        }
        if (input.length == 0) {
            return "";
        }
        if (alphabet.length() < base) {
            throw new InvalidInputException.InvalidAlphabet(base, alphabet);
        }
        int bitsPerChar = (int)Math.ceil(MathKt.log2((double)base));
        int blockSize = this.lcm(bitsPerChar, 8) / 8;
        int groupSize = blockSize * 8 / bitsPerChar;
        int mask = 255 >> 8 - bitsPerChar & 0xFF;
        String result = null;
        result = "";
        int index = 0;
        while (index < input.length) {
            int element$iv;
            int symbolsLeft = input.length - index;
            int padSize = symbolsLeft >= blockSize ? 0 : (blockSize - symbolsLeft) * 8 / bitsPerChar;
            long chunk = 0L;
            String chunkS = null;
            chunkS = "";
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)blockSize);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                byte by;
                byte by2;
                int blockIndex = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                long l = chunk;
                byte[] byArray = input;
                int n = index + blockIndex;
                if (n >= 0 && n <= ArraysKt.getLastIndex((byte[])byArray)) {
                    by2 = byArray[n];
                } else {
                    int n2 = n;
                    long l2 = l;
                    boolean bl2 = false;
                    byte by3 = 0;
                    l = l2;
                    by2 = by3;
                }
                chunk = l | (long)by2 << 8 * (blockSize - blockIndex - 1);
                StringBuilder stringBuilder = new StringBuilder().append(chunkS);
                byArray = input;
                n = index + blockIndex;
                if (n >= 0 && n <= ArraysKt.getLastIndex((byte[])byArray)) {
                    by = byArray[n];
                } else {
                    int it = n;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl3 = false;
                    byte by4 = 0;
                    stringBuilder = stringBuilder2;
                    by = by4;
                }
                chunkS = stringBuilder.append((char)by).toString();
            }
            index += blockSize;
            $this$forEach$iv = (Iterable)RangesKt.downTo((int)(groupSize - 1), (int)padSize);
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                long l = chunk >> bitsPerChar * i & (long)mask;
                result = result + alphabet.charAt((int)l);
            }
            if (!pad) continue;
            int n = 0;
            while (n < padSize) {
                int it = n++;
                boolean bl = false;
                result = result + '=';
            }
        }
        return result;
    }

    public static /* synthetic */ String encode$default(Base2N base2N, String string, int n, byte[] byArray, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return base2N.encode(string, n, byArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] decode(@NotNull String alphabet, int base, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)alphabet, (String)"alphabet");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if ((base & base - 1) != 0 || base == 0) {
            throw new InvalidInputException.InvalidBase("Provided base { " + base + " } is not a power of 2.");
        }
        if (((CharSequence)input).length() == 0) {
            return new byte[0];
        }
        if (alphabet.length() < base) {
            throw new InvalidInputException.InvalidAlphabet(base, alphabet);
        }
        int chunkSize = (int)Math.ceil(MathKt.log2((double)base));
        String data = StringsKt.replace$default((String)input, (String)"=", (String)"", (boolean)false, (int)4, null);
        byte[] result = new byte[data.length() * chunkSize / 8];
        CharSequence $this$forEachIndexed$iv = data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int i2 = n;
            boolean bl = false;
            int dataIndex = i2 * chunkSize / 8;
            if (dataIndex >= result.length) continue;
            byte b1 = result[dataIndex];
            byte b2 = dataIndex + 1 < result.length ? result[dataIndex + 1] : (byte)0;
            int fullChunk = b1 << 8 | b2 & 0xFF;
            int chunk = StringsKt.indexOf$default((CharSequence)alphabet, (char)c, (int)0, (boolean)false, (int)6, null);
            if (chunk < 0) {
                throw new InvalidInputException.InvalidCharacter((char)c, i2);
            }
            int shift = 16 - (i2 * chunkSize + chunkSize - dataIndex * 8);
            int rb1 = fullChunk | chunk << shift;
            result[dataIndex] = (byte)(rb1 >> 8);
            if (dataIndex + 1 >= result.length) continue;
            result[dataIndex + 1] = (byte)(rb1 & 0xFF);
        }
        return result;
    }

    private final int gcd(int a, int b) {
        return a == 0 ? b : this.gcd(b % a, a);
    }

    private final int lcm(int a, int b) {
        return a / this.gcd(a, b) * b;
    }
}

