/*
 * Decompiled with CFR 0.152.
 */
package com.funkatronics.buffer;

import com.ditchoom.buffer.BufferFactoryJvm;
import com.ditchoom.buffer.PlatformBuffer;
import com.funkatronics.buffer.ByteBuffer;
import com.funkatronics.buffer.ByteOrder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lcom/funkatronics/buffer/PlatformByteBuffer;", "Lcom/funkatronics/buffer/ByteBuffer;", "buffer", "Lcom/ditchoom/buffer/PlatformBuffer;", "(Lcom/ditchoom/buffer/PlatformBuffer;)V", "capacity", "", "getCapacity", "()I", "order", "Lcom/funkatronics/buffer/ByteOrder;", "getOrder", "()Lcom/funkatronics/buffer/ByteOrder;", "array", "", "get", "", "getDouble", "", "getFloat", "", "getInt", "getLong", "", "getShort", "", "put", "byte", "putDouble", "value", "putFloat", "putInt", "putLong", "putShort", "kborsh"})
@SourceDebugExtension(value={"SMAP\nPlatformByteBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformByteBuffer.kt\ncom/funkatronics/buffer/PlatformByteBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class PlatformByteBuffer
implements ByteBuffer {
    @NotNull
    private PlatformBuffer buffer;

    public PlatformByteBuffer(@NotNull PlatformBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
    }

    @Override
    public int getCapacity() {
        return this.buffer.getCapacity();
    }

    @Override
    @NotNull
    public ByteOrder getOrder() {
        ByteOrder byteOrder;
        switch (WhenMappings.$EnumSwitchMapping$0[this.buffer.getByteOrder().ordinal()]) {
            case 1: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case 2: {
                byteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byteOrder;
    }

    @Override
    @NotNull
    public ByteBuffer order(@NotNull ByteOrder order) {
        com.ditchoom.buffer.ByteOrder byteOrder;
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        byte[] byArray = this.buffer.readByteArray(this.buffer.getCapacity());
        switch (WhenMappings.$EnumSwitchMapping$1[order.ordinal()]) {
            case 1: {
                byteOrder = com.ditchoom.buffer.ByteOrder.BIG_ENDIAN;
                break;
            }
            case 2: {
                byteOrder = com.ditchoom.buffer.ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.buffer = BufferFactoryJvm.wrap((PlatformBuffer.Companion)PlatformBuffer.Companion, (byte[])byArray, (com.ditchoom.buffer.ByteOrder)byteOrder);
        return this;
    }

    @Override
    public byte get() {
        return this.buffer.readByte();
    }

    @Override
    public short getShort() {
        return this.buffer.readShort();
    }

    @Override
    public int getInt() {
        return this.buffer.readInt();
    }

    @Override
    public long getLong() {
        return this.buffer.readLong();
    }

    @Override
    public float getFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double getDouble() {
        return this.buffer.readDouble();
    }

    @Override
    @NotNull
    public ByteBuffer put(byte by) {
        PlatformByteBuffer platformByteBuffer;
        PlatformByteBuffer it = platformByteBuffer = this;
        boolean bl = false;
        this.buffer.writeByte(by);
        return platformByteBuffer;
    }

    @Override
    @NotNull
    public ByteBuffer putShort(short value) {
        PlatformByteBuffer platformByteBuffer;
        PlatformByteBuffer it = platformByteBuffer = this;
        boolean bl = false;
        this.buffer.writeShort(value);
        return platformByteBuffer;
    }

    @Override
    @NotNull
    public ByteBuffer putInt(int value) {
        PlatformByteBuffer platformByteBuffer;
        PlatformByteBuffer it = platformByteBuffer = this;
        boolean bl = false;
        this.buffer.writeInt(value);
        return platformByteBuffer;
    }

    @Override
    @NotNull
    public ByteBuffer putLong(long value) {
        PlatformByteBuffer platformByteBuffer;
        PlatformByteBuffer it = platformByteBuffer = this;
        boolean bl = false;
        this.buffer.writeLong(value);
        return platformByteBuffer;
    }

    @Override
    @NotNull
    public ByteBuffer putFloat(float value) {
        PlatformByteBuffer platformByteBuffer;
        PlatformByteBuffer it = platformByteBuffer = this;
        boolean bl = false;
        this.buffer.writeFloat(value);
        return platformByteBuffer;
    }

    @Override
    @NotNull
    public ByteBuffer putDouble(double value) {
        PlatformByteBuffer platformByteBuffer;
        PlatformByteBuffer it = platformByteBuffer = this;
        boolean bl = false;
        this.buffer.writeDouble(value);
        return platformByteBuffer;
    }

    @Override
    @NotNull
    public byte[] array() {
        byte[] byArray;
        byte[] $this$array_u24lambda_u246 = byArray = new byte[this.buffer.getCapacity()];
        boolean bl = false;
        this.buffer.position(0);
        this.get($this$array_u24lambda_u246);
        return byArray;
    }

    @Override
    public void get(@NotNull byte[] dst) {
        ByteBuffer.DefaultImpls.get(this, dst);
    }

    @Override
    @NotNull
    public ByteBuffer put(@NotNull byte[] bytes) {
        return ByteBuffer.DefaultImpls.put(this, bytes);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[com.ditchoom.buffer.ByteOrder.values().length];
            try {
                nArray[com.ditchoom.buffer.ByteOrder.LITTLE_ENDIAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.ditchoom.buffer.ByteOrder.BIG_ENDIAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ByteOrder.values().length];
            try {
                nArray[ByteOrder.BIG_ENDIAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ByteOrder.LITTLE_ENDIAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

