/*
 * Decompiled with CFR 0.152.
 */
package com.freddy.silhouette.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Insets;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcom/freddy/silhouette/utils/DensityUtil;", "", "()V", "dp2px", "", "dp", "", "getScreenHeight", "context", "Landroid/content/Context;", "getScreenWidth", "sp2px", "sp", "silhouette_release"})
public final class DensityUtil {
    @NotNull
    public static final DensityUtil INSTANCE = new DensityUtil();

    private DensityUtil() {
    }

    public final int dp2px(float dp) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public final int sp2px(float sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public final int getScreenWidth(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = wm.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"wm.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            Insets insets = windowMetrics2.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"windowMetrics.windowInse\u2026Insets.Type.systemBars())");
            Insets insets2 = insets;
            n = windowMetrics2.getBounds().width() - insets2.left - insets2.right;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.widthPixels;
        }
        return n;
    }

    public final int getScreenHeight(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = wm.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"wm.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            Insets insets = windowMetrics2.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"windowMetrics.windowInse\u2026Insets.Type.systemBars())");
            Insets insets2 = insets;
            n = windowMetrics2.getBounds().height() - insets2.top - insets2.bottom;
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.heightPixels;
        }
        return n;
    }
}

