/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourlastor.construo.task.linux;

import io.github.fourlastor.construo.Target;
import io.github.fourlastor.construo.task.BaseTask;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lio/github/fourlastor/construo/task/linux/BuildAppImage;", "Lio/github/fourlastor/construo/task/BaseTask;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/process/ExecOperations;)V", "appImageFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAppImageFile", "()Lorg/gradle/api/file/RegularFileProperty;", "architecture", "Lorg/gradle/api/provider/Property;", "Lio/github/fourlastor/construo/Target$Architecture;", "getArchitecture", "()Lorg/gradle/api/provider/Property;", "imageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getImageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "imagesToolsDir", "getImagesToolsDir", "run", "", "runtimeName", "", "arch", "construo"})
public abstract class BuildAppImage
extends BaseTask {
    @NotNull
    private final ExecOperations execOperations;

    @Inject
    public BuildAppImage(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
    }

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getImagesToolsDir();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getImageDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAppImageFile();

    @Input
    @NotNull
    public abstract Property<Target.Architecture> getArchitecture();

    @TaskAction
    public final void run() {
        this.execOperations.exec(new Action(this){
            final /* synthetic */ BuildAppImage this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                $this$exec.setWorkingDir((Object)this.this$0.getImagesToolsDir());
                Object object = this.this$0.getArchitecture().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"architecture.get()");
                Target.Architecture architecture = (Target.Architecture)((Object)object);
                String arch = architecture.getArch();
                $this$exec.environment(MapsKt.mapOf((Pair)TuplesKt.to((Object)"ARCH", (Object)arch)));
                String appImageTemplateDirPath = ((File)this.this$0.getImageDir().getAsFile().get()).getAbsolutePath();
                String targetPath = ((File)this.this$0.getAppImageFile().getAsFile().get()).getAbsolutePath();
                Object[] objectArray = new Object[]{"./appimagetool-x86_64.AppImage", "-n", appImageTemplateDirPath, targetPath, "--runtime-file", "./" + BuildAppImage.access$runtimeName(this.this$0, architecture)};
                $this$exec.commandLine(objectArray);
            }
        });
    }

    private final String runtimeName(Target.Architecture arch) {
        return switch (WhenMappings.$EnumSwitchMapping$0[arch.ordinal()]) {
            case 1 -> "runtime-aarch64";
            case 2 -> "runtime-x86_64";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ String access$runtimeName(BuildAppImage $this, Target.Architecture arch) {
        return $this.runtimeName(arch);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Target.Architecture.values().length];
            try {
                nArray[Target.Architecture.AARCH64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Target.Architecture.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

