/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.transport.WebSocketTransportFactory;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends WebSocketClient
implements ConnectionTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketTransport.class);
    private Connection connection = null;

    public WebSocketTransport(URI serverUri, Draft draft) {
        super(serverUri, draft);
    }

    public WebSocketTransport(URI serverURI) {
        super(serverURI);
    }

    public WebSocketTransport(URI serverUri, Map<String, String> httpHeaders) {
        super(serverUri, httpHeaders);
    }

    public static WebSocketTransport create(String browserWSEndpoint) throws InterruptedException {
        return WebSocketTransportFactory.create(browserWSEndpoint);
    }

    @Override
    public void onMessage(String message) {
        Objects.requireNonNull(this.connection, "Connection may be closed");
        this.connection.accept(message);
    }

    public void onClose(int code, String reason, boolean remote) {
        LOGGER.info("Connection closed by {} Code: {} Reason: {}", new Object[]{remote ? "remote peer" : "us", code, StringUtil.isEmpty(reason) ? Constant.CLOSE_REASON.get(code) : reason});
        if (this.connection != null) {
            this.connection.dispose();
        }
    }

    public void onError(Exception e) {
        LOGGER.error("Websocket error:", (Throwable)e);
    }

    public void onOpen(ServerHandshake serverHandshake) {
        LOGGER.info("Websocket serverHandshake status: {}", (Object)serverHandshake.getHttpStatus());
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

