/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.transport.Callback;
import com.ruiyun.jvppeteer.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class CallbackRegistry {
    private final Map<Long, Callback> callbacks = new ConcurrentHashMap<Long, Callback>();
    private final Map<Long, Callback> eventCallbacks = new ConcurrentHashMap<Long, Callback>();

    public JsonNode create(Callback callback, Consumer<Long> request, boolean isBlocking) {
        this.put(callback, isBlocking);
        try {
            request.accept(callback.id());
            if (!isBlocking) {
                return null;
            }
            return callback.waitForResponse();
        }
        catch (InterruptedException e) {
            this.callbacks.remove(callback.id());
            callback.reject();
            Helper.throwError(e);
            return null;
        }
    }

    private void put(Callback callback, boolean isBlocking) {
        if (isBlocking) {
            String name = Thread.currentThread().getName();
            if (name.startsWith("JvEmitEventThread-")) {
                this.eventCallbacks.put(callback.id(), callback);
            } else {
                this.callbacks.put(callback.id(), callback);
            }
        }
    }

    public void reject(long id, String message, int code, boolean handleListenerThread) {
        if (handleListenerThread) {
            Callback eventCallback = this.eventCallbacks.remove(id);
            if (eventCallback != null) {
                this._reject(eventCallback, message, code);
                this.callbacks.remove(id);
            }
        } else {
            Callback callback = this.callbacks.remove(id);
            if (callback != null) {
                this._reject(callback, message, code);
            }
        }
    }

    private void _reject(Callback callback, String errorMessage, int code) {
        callback.reject("Protocol error (method\uff1a" + callback.label() + "): " + errorMessage, code);
    }

    public void resolve(long id, JsonNode value, boolean handleListenerThread) {
        if (handleListenerThread) {
            Callback eventCallback = this.eventCallbacks.remove(id);
            if (eventCallback != null) {
                eventCallback.resolve(value);
                this.callbacks.remove(id);
            }
        } else {
            Callback callback = this.callbacks.remove(id);
            if (callback != null) {
                callback.resolve(value);
            }
        }
    }

    public void clear() {
        this.callbacks.forEach((key, callback) -> this._reject((Callback)callback, "Target closed", 0));
    }

    public List<ProtocolException> getPendingProtocolErrors() {
        ArrayList<ProtocolException> results = new ArrayList<ProtocolException>();
        this.callbacks.forEach((key, callback) -> {
            String errorMsg = callback.errorMsg();
            if (errorMsg != null) {
                results.add(new ProtocolException(errorMsg + " timed out. Trace: "));
            }
        });
        return results;
    }
}

