/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.core.Target;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CallbackRegistry;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDPSession
extends EventEmitter<CDPSessionEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDPSession.class);
    private final String targetType;
    private final String sessionId;
    private Connection connection;
    private final String parentSessionId;
    private Target target;
    private List<String> events = null;

    public CDPSession(Connection connection, String targetType, String sessionId, String parentSessionId) {
        this.targetType = targetType;
        this.sessionId = sessionId;
        this.connection = connection;
        this.parentSessionId = parentSessionId;
    }

    public CDPSession parentSession() {
        if (StringUtil.isEmpty(this.parentSessionId)) {
            return this;
        }
        if (this.connection != null) {
            return this.connection.session(this.parentSessionId);
        }
        return null;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void onClosed() {
        this.connection = null;
        this.emit(CDPSessionEvent.CDPSession_Disconnected, true);
    }

    public JsonNode send(String method) {
        return this.send(method, null);
    }

    public JsonNode send(String method, Map<String, Object> params) {
        return this.send(method, params, null, true);
    }

    public JsonNode send(String method, Map<String, Object> params, Integer timeout, boolean isBlocking) {
        if (this.connection == null || this.connection.closed) {
            throw new JvppeteerException("Protocol error (" + method + "): Session closed. Most likely the" + this.targetType + "has been closed.");
        }
        return this.connection.rawSend(method, params, this.sessionId, timeout, isBlocking);
    }

    public void detach() {
        if (this.connection == null) {
            throw new JvppeteerException("Session already detached. Most likely the" + this.targetType + "has been closed.");
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("sessionId", this.sessionId);
        this.connection.send("Target.detachFromTarget", params);
    }

    public boolean onMessage(JsonNode response, CallbackRegistry callbacks) {
        JsonNode paramsNode = response.get("params");
        JsonNode methodNode = response.get("method");
        try {
            if (!response.hasNonNull("id")) {
                boolean match;
                ValidateUtil.assertArg(!response.hasNonNull("id"), "Should not contain id, " + response);
                String method = methodNode.asText();
                if (this.events == null) {
                    this.events = Arrays.stream(CDPSessionEvent.values()).map(CDPSessionEvent::getEventName).collect(Collectors.toList());
                }
                if (!(match = this.events.contains(method))) {
                    return false;
                }
                if (this.connection == null) {
                    return false;
                }
                this.connection.getEventQueue().offer(() -> {
                    try {
                        this.emit(CDPSessionEvent.valueOf(method.replace(".", "_")), Constant.LISTENNER_CLASSES.get(method) == null ? Boolean.valueOf(true) : Constant.OBJECTMAPPER.treeToValue((TreeNode)paramsNode, Constant.LISTENNER_CLASSES.get(method)));
                    }
                    catch (JsonProcessingException | IllegalArgumentException e) {
                        LOGGER.error("emit error", e);
                    }
                });
                return true;
            }
            long id = response.get("id").asLong();
            Connection.resolveCallback(callbacks, response, id, false);
        }
        catch (Exception e) {
            LOGGER.error("emit error", (Throwable)e);
        }
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String id() {
        return this.sessionId;
    }

    public Target getTarget() {
        Objects.requireNonNull(this.target, "Target must exist");
        return this.target;
    }

    public static enum CDPSessionEvent {
        CDPSession_Disconnected("CDPSession.Disconnected"),
        CDPSession_Swapped("CDPSession.Swapped"),
        CDPSession_Ready("CDPSession.Ready"),
        sessionAttached("sessionattached"),
        sessionDetached("sessiondetached"),
        Page_domContentEventFired("Page.domContentEventFired"),
        Page_loadEventFired("Page.loadEventFired"),
        Page_javascriptDialogOpening("Page.javascriptDialogOpening"),
        Page_fileChooserOpened("Page.fileChooserOpened"),
        Page_frameStartedLoading("Page.frameStartedLoading"),
        Page_frameAttached("Page.frameAttached"),
        Page_frameNavigated("Page.frameNavigated"),
        Page_navigatedWithinDocument("Page.navigatedWithinDocument"),
        Page_frameDetached("Page.frameDetached"),
        Page_frameStoppedLoading("Page.frameStoppedLoading"),
        Page_lifecycleEvent("Page.lifecycleEvent"),
        Page_screencastFrame("Page.screencastFrame"),
        Runtime_executionContextCreated("Runtime.executionContextCreated"),
        Runtime_executionContextDestroyed("Runtime.executionContextDestroyed"),
        Runtime_executionContextsCleared("Runtime.executionContextsCleared"),
        Runtime_exceptionThrown("Runtime.exceptionThrown"),
        Runtime_consoleAPICalled("Runtime.consoleAPICalled"),
        Runtime_bindingCalled("Runtime.bindingCalled"),
        Inspector_targetCrashed("Inspector.targetCrashed"),
        Performance_metrics("Performance.metrics"),
        Log_entryAdded("Log.entryAdded"),
        Target_targetCreated("Target.targetCreated"),
        Target_targetDestroyed("Target.targetDestroyed"),
        Target_targetInfoChanged("Target.targetInfoChanged"),
        Target_attachedToTarget("Target.attachedToTarget"),
        Target_detachedFromTarget("Target.detachedFromTarget"),
        Debugger_scriptParsed("Debugger.scriptParsed"),
        CSS_styleSheetAdded("CSS.styleSheetAdded"),
        DeviceAccess_deviceRequestPrompted("DeviceAccess.deviceRequestPrompted"),
        targetcreated("targetcreated"),
        targetdestroyed("targetdestroyed"),
        targetchanged("targetchanged"),
        disconnected("disconnected"),
        Fetch_requestPaused("Fetch.requestPaused"),
        Fetch_authRequired("Fetch.authRequired"),
        Network_requestWillBeSent("Network.requestWillBeSent"),
        Network_requestServedFromCache("Network.requestServedFromCache"),
        Network_responseReceived("Network.responseReceived"),
        Network_loadingFinished("Network.loadingFinished"),
        Network_loadingFailed("Network.loadingFailed"),
        Network_responseReceivedExtraInfo("Network.responseReceivedExtraInfo"),
        Tracing_tracingComplete("Tracing.tracingComplete"),
        Input_dragIntercepted("Input.dragIntercepted");

        private String eventName;

        private CDPSessionEvent(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }
    }
}

