/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitter<EventType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventEmitter.class);
    private final Map<EventType, List<Consumer<?>>> listeners = new ConcurrentHashMap();

    public EventEmitter<EventType> on(EventType eventType, Consumer<?> listener) {
        List list = this.listeners.computeIfAbsent(eventType, k -> Collections.synchronizedList(new ArrayList()));
        list.add(listener);
        return this;
    }

    public void off(EventType eventType, Consumer<?> listener) {
        List<Consumer<Consumer<?>>> list = this.listeners.get(eventType);
        if (list == null) {
            return;
        }
        list.removeAll(Collections.singleton(listener));
        if (list.isEmpty()) {
            this.listeners.remove(eventType);
        }
    }

    public void once(EventType eventType, Consumer<?> listener) {
        AtomicReference<Consumer<Object>> consumerRef = new AtomicReference<Consumer<Object>>();
        Consumer<Object> offConsumer = s -> this.off(eventType, (Consumer)consumerRef.get());
        Consumer<Object> consumer = listener.andThen(offConsumer);
        consumerRef.set(consumer);
        this.on(eventType, consumer);
    }

    public <T> void emit(EventType eventType, T param) {
        List<Consumer<?>> list = this.listeners.get(eventType);
        if (list == null) {
            return;
        }
        for (Consumer<?> listener : new ArrayList(list)) {
            if (listener == null) continue;
            try {
                listener.accept(param);
            }
            catch (Exception e) {
                LOGGER.error("jvppeteer error", (Throwable)e);
            }
        }
    }

    public int listenerCount(EventType eventType) {
        return this.listeners.get(eventType) == null ? 0 : this.listeners.get(eventType).size();
    }

    public void removeAllListener(EventType eventType) {
        if (eventType == null) {
            this.listeners.clear();
            return;
        }
        this.listeners.remove(eventType);
    }

    public void removeListener(EventType eventType, Consumer<?> listener) {
        List<Consumer<?>> consumers = this.listeners.get(eventType);
        if (consumers == null) {
            return;
        }
        consumers.remove(listener);
    }

    public void dispose() {
        this.listeners.clear();
    }
}

