/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.entities;

import com.ruiyun.jvppeteer.common.BindingFunction;
import com.ruiyun.jvppeteer.core.ExecutionContext;
import com.ruiyun.jvppeteer.core.JSHandle;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Binding {
    private static final Logger LOGGER = LoggerFactory.getLogger(Binding.class);
    private final String name;
    private final BindingFunction fn;
    private final String initSource;

    public Binding(String name, BindingFunction fn, String initSource) {
        this.name = name;
        this.fn = fn;
        this.initSource = initSource;
    }

    public String name() {
        return this.name;
    }

    public String initSource() {
        return this.initSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ExecutionContext context, int id, List<Object> args, boolean isTrivial) {
        try {
            ArrayList<Object> params;
            if (!isTrivial) {
                params = new ArrayList<Object>();
                params.add(this.name);
                params.add(id);
                JSHandle handles = context.evaluateHandle("(name, seq) => {\n            // @ts-expect-error Code is evaluated in a different context.\n            return globalThis[name].args.get(seq);\n          }", params);
                try {
                    Map<String, JSHandle> map = handles.getProperties();
                    map.forEach((key, handle) -> {
                        if (args.contains(key)) {
                            if (handle.getRemoteObject().getSubtype().equals("node")) {
                                args.set(Integer.parseInt(key), handle);
                            } else {
                                handle.dispose();
                            }
                        } else {
                            handle.dispose();
                        }
                    });
                }
                finally {
                    if (handles != null) {
                        handles.dispose();
                    }
                }
            }
            params = new ArrayList();
            params.add(this.name);
            params.add(id);
            params.add(this.fn.bind(args));
            context.evaluate("(name, seq, result) => {\n            // @ts-expect-error Code is evaluated in a different context.\n          const callbacks = globalThis[name].callbacks;\n            callbacks.get(seq).resolve(result);\n            callbacks.delete(seq);\n        }", params);
            for (Object e : args) {
                if (!(e instanceof JSHandle)) continue;
                ((JSHandle)e).dispose();
            }
        }
        catch (Exception e) {
            if (e instanceof EvaluateException) {
                try {
                    ArrayList<Object> params = new ArrayList<Object>();
                    params.add(this.name);
                    params.add(id);
                    params.add(e.getMessage());
                    context.evaluate("(name, seq, message) => {\n              const error = new Error(message);\n                // @ts-expect-error Code is evaluated in a different context.\n              const callbacks = globalThis[name].callbacks;\n                callbacks.get(seq).reject(error);\n                callbacks.delete(seq);\n            }", params);
                }
                catch (Exception ex) {
                    LOGGER.error("jvppeteer error: ", (Throwable)e);
                }
            }
            try {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(this.name);
                params.add(id);
                context.evaluate(" (name, seq) => {\n             const error = new Error();\n                    // @ts-expect-error Code is evaluated in a different context.\n              const callbacks = globalThis[name].callbacks;\n                    callbacks.get(seq).reject(error);\n                    callbacks.delete(seq);\n                }", params);
            }
            catch (Exception ex) {
                LOGGER.error("jvppeteer error: ", (Throwable)e);
            }
        }
    }
}

