/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.common.ConsoleAPI;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.core.ExecutionContext;
import com.ruiyun.jvppeteer.core.IsolatedWorld;
import com.ruiyun.jvppeteer.core.JSHandle;
import com.ruiyun.jvppeteer.core.Realm;
import com.ruiyun.jvppeteer.entities.ConsoleMessageType;
import com.ruiyun.jvppeteer.entities.RemoteObject;
import com.ruiyun.jvppeteer.entities.TargetType;
import com.ruiyun.jvppeteer.events.ExceptionThrownEvent;
import com.ruiyun.jvppeteer.events.IsolatedWorldEmitter;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.util.Helper;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class WebWorker {
    private final IsolatedWorld world;
    private final CDPSession client;
    private final String id;
    private final TargetType targetType;
    private final String url;
    private ExecutionContext context;

    public WebWorker(CDPSession client, String url, String targetId, TargetType targetType, ConsoleAPI consoleAPICalled, Consumer<ExceptionThrownEvent> exceptionThrown) {
        this.url = url;
        this.id = targetId;
        this.client = client;
        this.targetType = targetType;
        TimeoutSettings timeoutSettings = new TimeoutSettings();
        this.world = new IsolatedWorld(null, this, timeoutSettings);
        this.client.once(CDPSession.CDPSessionEvent.Runtime_executionContextCreated, event -> this.world.setContext(new ExecutionContext(client, event.getContext(), this.world)));
        this.world.emitter().on(IsolatedWorldEmitter.IsolatedWorldEventType.Consoleapicalled, event -> consoleAPICalled.call(ConsoleMessageType.valueOf(event.getType().toUpperCase()), event.getArgs().stream().map(object -> new JSHandle(this.world, (RemoteObject)object)).collect(Collectors.toList()), event.getStackTrace()));
        this.client.on(CDPSession.CDPSessionEvent.Runtime_exceptionThrown, exceptionThrown);
        this.client.once(CDPSession.CDPSessionEvent.CDPSession_Disconnected, ignored -> this.world.dispose());
    }

    public Realm mainRealm() {
        return this.world;
    }

    public CDPSession client() {
        return this.client;
    }

    public void close() throws EvaluateException, JsonProcessingException {
        switch (this.targetType) {
            case SERVICE_WORKER: 
            case SHARED_WORKER: {
                Connection connection = this.client.getConnection();
                if (connection == null) break;
                Map<String, Object> params = ParamsFactory.create();
                params.put("targetId", this.id);
                connection.send("Target.closeTarget", params);
                params.clear();
                params.put("sessionId", this.client.id());
                connection.send("Target.detachFromTarget", params, null, false);
                break;
            }
            default: {
                this.evaluate("() => {\n          self.close();\n        }");
            }
        }
    }

    public String url() {
        return this.url;
    }

    public Object evaluate(String pageFunction) throws EvaluateException, JsonProcessingException {
        return this.evaluate(pageFunction, null);
    }

    public JSHandle evaluateHandle(String pageFunction) throws EvaluateException, JsonProcessingException {
        return this.evaluateHandle(pageFunction, null);
    }

    public JSHandle evaluateHandle(String pageFunction, List<Object> args) throws EvaluateException, JsonProcessingException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pageFunction);
        return this.mainRealm().evaluateHandle(pageFunction, args);
    }

    public Object evaluate(String pageFunction, List<Object> args) throws EvaluateException, JsonProcessingException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pageFunction);
        return this.mainRealm().evaluate(pageFunction, args);
    }
}

