/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.core.Keyboard;
import com.ruiyun.jvppeteer.entities.TouchPoint;
import com.ruiyun.jvppeteer.transport.CDPSession;
import java.util.ArrayList;
import java.util.Map;

public class Touchscreen {
    private CDPSession client;
    private final Keyboard keyboard;

    public Touchscreen(CDPSession client, Keyboard keyboard) {
        this.client = client;
        this.keyboard = keyboard;
    }

    public void tap(double x, double y) {
        this.touchStart(x, y);
        this.touchEnd();
    }

    public void touchStart(double x, double y) {
        Map<String, Object> params = ParamsFactory.create();
        params.put("type", "touchStart");
        ArrayList<TouchPoint> touchPoints = new ArrayList<TouchPoint>();
        TouchPoint touchPoint = new TouchPoint();
        touchPoint.setX(Math.round(x));
        touchPoint.setY(Math.round(y));
        touchPoint.setRadiusX(0.5);
        touchPoint.setRadiusY(0.5);
        touchPoint.setForce(0.5);
        touchPoints.add(touchPoint);
        params.put("touchPoints", touchPoints);
        params.put("modifiers", this.keyboard.getModifiers());
        this.client.send("Input.dispatchTouchEvent", params);
    }

    public void touchMove(double x, double y) {
        Map<String, Object> params = ParamsFactory.create();
        params.put("type", "touchMove");
        ArrayList<TouchPoint> touchPoints = new ArrayList<TouchPoint>();
        TouchPoint touchPoint = new TouchPoint();
        touchPoint.setX(Math.round(x));
        touchPoint.setY(Math.round(y));
        touchPoint.setRadiusX(0.5);
        touchPoint.setRadiusY(0.5);
        touchPoint.setForce(0.5);
        touchPoints.add(touchPoint);
        params.put("touchPoints", touchPoints);
        params.put("modifiers", this.keyboard.getModifiers());
        this.client.send("Input.dispatchTouchEvent", params);
    }

    public void touchEnd() {
        Map<String, Object> params = ParamsFactory.create();
        params.put("type", "touchEnd");
        ArrayList touchPoints = new ArrayList();
        params.put("touchPoints", touchPoints);
        params.put("modifiers", this.keyboard.getModifiers());
        this.client.send("Input.dispatchTouchEvent", params);
    }

    public void updateClient(CDPSession client) {
        this.client = client;
    }
}

