/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.Environment;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.core.Browser;
import com.ruiyun.jvppeteer.core.BrowserFetcher;
import com.ruiyun.jvppeteer.entities.ConnectOptions;
import com.ruiyun.jvppeteer.entities.FetcherOptions;
import com.ruiyun.jvppeteer.entities.LaunchOptions;
import com.ruiyun.jvppeteer.entities.RevisionInfo;
import com.ruiyun.jvppeteer.launch.ChromeLauncher;
import com.ruiyun.jvppeteer.launch.Launcher;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;

public class Puppeteer {
    private Product product = Product.CHROME;
    private Launcher launcher;
    private Environment env = null;
    private String cacheDir;

    public Puppeteer() {
        this.cacheDir = Helper.join(System.getProperty("user.dir"), ".local-browser");
    }

    public Puppeteer(String cacheDir, Product product) {
        this.cacheDir = StringUtil.isBlank(cacheDir) ? Helper.join(System.getProperty("user.dir"), ".local-browser") : cacheDir;
        this.product = product;
    }

    public static Browser launch() throws IOException {
        return Puppeteer.launch(true);
    }

    public static Browser launch(boolean headless) throws IOException {
        return Puppeteer.launch(LaunchOptions.builder().headless(headless).build());
    }

    public static Browser launch(LaunchOptions options) throws IOException {
        Puppeteer puppeteer = new Puppeteer();
        return Puppeteer.rawLaunch(options, puppeteer);
    }

    public static Browser rawLaunch(LaunchOptions options, Puppeteer puppeteer) throws IOException {
        if (options.getProduct() != null) {
            puppeteer.setProduct(options.getProduct());
        }
        if (StringUtil.isNotBlank(options.getCacheDir())) {
            puppeteer.setCacheDir(options.getCacheDir());
        }
        Puppeteer.adoptLauncher(puppeteer);
        return puppeteer.getLauncher().launch(options);
    }

    private static Browser connect(ConnectOptions options) throws IOException, InterruptedException {
        Puppeteer puppeteer = new Puppeteer();
        Puppeteer.adoptLauncher(puppeteer);
        return puppeteer.getLauncher().connect(options);
    }

    public static Browser connect(String browserWSEndpointOrURL) throws IOException, InterruptedException {
        ConnectOptions options = new ConnectOptions();
        if (browserWSEndpointOrURL.startsWith("ws:")) {
            options.setBrowserWSEndpoint(browserWSEndpointOrURL);
        } else {
            options.setBrowserURL(browserWSEndpointOrURL);
        }
        return Puppeteer.connect(options);
    }

    public static Browser connect(ConnectionTransport transport) throws IOException, InterruptedException {
        ConnectOptions options = new ConnectOptions();
        options.setTransport(transport);
        return Puppeteer.connect(options);
    }

    private static void adoptLauncher(Puppeteer puppeteer) {
        Product product = puppeteer.getProduct();
        if (product == null) {
            Environment env = puppeteer.getEnv();
            if (env == null) {
                env = System::getenv;
                puppeteer.setEnv(env);
            }
            for (String envProductName : Constant.PRODUCT_ENV) {
                String productName = env.getEnv(envProductName);
                if (!StringUtil.isNotEmpty(productName)) continue;
                product = Product.valueOf(productName);
                puppeteer.setProduct(product);
                break;
            }
        }
        if (product == null) {
            product = Product.CHROME;
            puppeteer.setProduct(product);
        }
        switch (product) {
            case FIREFOX: {
                throw new IllegalArgumentException("Firefox browser is not supported yet!");
            }
        }
        ChromeLauncher launcher = new ChromeLauncher(puppeteer.getCacheDir(), product);
        puppeteer.setLauncher(launcher);
    }

    public static RevisionInfo downloadBrowser() throws IOException, InterruptedException {
        return Puppeteer.downloadBrowser("128.0.6613.137");
    }

    public static RevisionInfo downloadBrowser(FetcherOptions options) throws IOException, InterruptedException {
        if (StringUtil.isBlank(options.getCacheDir())) {
            options.setCacheDir(Helper.join(System.getProperty("user.dir"), ".local-browser"));
        }
        BrowserFetcher fetcher = new BrowserFetcher(options);
        return fetcher.downloadBrowser();
    }

    public static RevisionInfo downloadBrowser(String version) throws IOException, InterruptedException {
        ValidateUtil.assertArg(StringUtil.isNotBlank(version), "Browser version must be specified");
        FetcherOptions options = new FetcherOptions();
        options.setVersion(version);
        return Puppeteer.downloadBrowser(options);
    }

    private Launcher getLauncher() {
        return this.launcher;
    }

    private void setLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    private Environment getEnv() {
        return this.env;
    }

    private void setEnv(Environment env) {
        this.env = env;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }
}

