/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.core.ElementHandle;
import com.ruiyun.jvppeteer.core.IsolatedWorld;
import com.ruiyun.jvppeteer.core.Realm;
import com.ruiyun.jvppeteer.entities.RemoteObject;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSHandle {
    private final RemoteObject remoteObject;
    private boolean disposed = false;
    private final IsolatedWorld world;

    JSHandle(IsolatedWorld world, RemoteObject remoteObject) {
        this.world = world;
        this.remoteObject = remoteObject;
    }

    public boolean disposed() {
        return this.disposed;
    }

    public Realm realm() {
        return this.world;
    }

    public CDPSession client() {
        return this.realm().environment().client();
    }

    public Object jsonValue() throws JsonProcessingException, EvaluateException {
        if (StringUtil.isNotEmpty(this.remoteObject.getObjectId())) {
            Object value = this.evaluate("object => {\n      return object;\n    }", new ArrayList<Object>());
            if (value == null) {
                throw new JvppeteerException("Could not serialize referenced object");
            }
            return value;
        }
        return Helper.valueFromRemoteObject(this.remoteObject);
    }

    public ElementHandle asElement() {
        return null;
    }

    public Object evaluate(String pageFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pageFunction);
        ArrayList<Object> argsArray = new ArrayList<Object>();
        argsArray.add(this);
        if (args != null) {
            argsArray.addAll(args);
        }
        return this.realm().evaluate(pageFunction, argsArray);
    }

    public JSHandle evaluateHandle(String pageFunction) throws JsonProcessingException, EvaluateException {
        return this.evaluateHandle(pageFunction, null);
    }

    public JSHandle evaluateHandle(String pageFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pageFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pageFunction);
        ArrayList<Object> argsArray = new ArrayList<Object>();
        argsArray.add(this);
        if (args != null) {
            argsArray.addAll(args);
        }
        return this.realm().evaluateHandle(pageFunction, argsArray);
    }

    public JSHandle getProperty(String propertyName) throws JsonProcessingException, EvaluateException {
        String pageFunction = "(object, propertyName) => {\n      return object[propertyName];\n    }";
        return this.evaluateHandle(pageFunction, Collections.singletonList(propertyName));
    }

    public Map<String, JSHandle> getProperties() throws JsonProcessingException {
        Map<String, Object> params = ParamsFactory.create();
        params.put("objectId", this.remoteObject.getObjectId());
        params.put("ownProperties", true);
        JsonNode response = this.client().send("Runtime.getProperties", params);
        LinkedHashMap<String, JSHandle> result = new LinkedHashMap<String, JSHandle>();
        for (JsonNode property : response.get("result")) {
            if (!property.get("enumerable").asBoolean() || !property.hasNonNull("value")) continue;
            result.put(property.get("name").asText(), this.world.createJSHandle((RemoteObject)Constant.OBJECTMAPPER.treeToValue((TreeNode)property.get("value"), RemoteObject.class)));
        }
        return result;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Helper.releaseObject(this.client(), this.remoteObject);
    }

    public String toString() {
        if (StringUtil.isNotEmpty(this.remoteObject.getObjectId())) {
            String type = StringUtil.isNotEmpty(this.remoteObject.getSubtype()) ? this.remoteObject.getSubtype() : this.remoteObject.getType();
            return "JSHandle@" + type;
        }
        return "JSHandle:" + Helper.valueFromRemoteObject(this.remoteObject);
    }

    public RemoteObject getRemoteObject() {
        return this.remoteObject;
    }

    public String id() {
        return this.remoteObject.getObjectId();
    }
}

