/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.DeviceRequestPromptManager;
import com.ruiyun.jvppeteer.common.FrameProvider;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.core.ExecutionContext;
import com.ruiyun.jvppeteer.core.Frame;
import com.ruiyun.jvppeteer.core.FrameTree;
import com.ruiyun.jvppeteer.core.FrameTreeEvent;
import com.ruiyun.jvppeteer.core.IsolatedWorld;
import com.ruiyun.jvppeteer.core.NetworkManager;
import com.ruiyun.jvppeteer.core.Page;
import com.ruiyun.jvppeteer.core.Target;
import com.ruiyun.jvppeteer.entities.Binding;
import com.ruiyun.jvppeteer.entities.ExecutionContextDescription;
import com.ruiyun.jvppeteer.entities.FramePayload;
import com.ruiyun.jvppeteer.entities.NewDocumentScriptEvaluation;
import com.ruiyun.jvppeteer.entities.PreloadScript;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.events.LifecycleEvent;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.TargetCloseException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameManager
extends EventEmitter<FrameManagerEvent>
implements FrameProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameManager.class);
    private static final String UTILITY_WORLD_NAME = "__puppeteer_utility_world__";
    private final Page page;
    private final NetworkManager networkManager;
    private final TimeoutSettings timeoutSettings;
    private final Set<String> isolatedWorlds = new HashSet<String>();
    private CDPSession client;
    private final Map<String, PreloadScript> scriptsToEvaluateOnNewDocument = new HashMap<String, PreloadScript>();
    private final Set<Binding> bindings = new HashSet<Binding>();
    private final FrameTree frameTree = new FrameTree();
    private final Set<String> frameNavigatedReceived = new HashSet<String>();
    private final Map<CDPSession, DeviceRequestPromptManager> deviceRequestPromptManagerMap = new WeakHashMap<CDPSession, DeviceRequestPromptManager>();
    private AwaitableResult<Boolean> frameTreeHandled;

    public FrameManager(CDPSession client, Page page, TimeoutSettings timeoutSettings) {
        this.client = client;
        this.page = page;
        this.networkManager = new NetworkManager(this);
        this.timeoutSettings = timeoutSettings;
        this.setupEventListeners(this.client);
        client.once(CDPSession.CDPSessionEvent.CDPSession_Disconnected, ignored -> {
            try {
                this.onClientDisconnect();
            }
            catch (Exception e) {
                LOGGER.error("onClientDisconnect error", (Throwable)e);
            }
        });
    }

    public Page page() {
        return this.page;
    }

    private void onClientDisconnect() {
        Frame mainFrame = this.frameTree.getMainFrame();
        if (mainFrame == null) {
            return;
        }
        mainFrame.childFrames().forEach(this::removeFramesRecursively);
        AwaitableResult swappedSubject = AwaitableResult.create();
        Consumer<Object> onSwapped = ignored -> swappedSubject.onSuccess(true);
        try {
            mainFrame.once(Frame.FrameEvent.FrameSwappedByActivation, onSwapped);
            swappedSubject.waiting(100, TimeUnit.MILLISECONDS);
        }
        catch (Exception err) {
            this.removeFramesRecursively(mainFrame);
        }
    }

    public void swapFrameTree(CDPSession client) {
        this.client = client;
        Frame frame = this.frameTree.getMainFrame();
        if (frame != null) {
            this.frameNavigatedReceived.add(this.client.getTarget().getTargetId());
            this.frameTree.removeFrame(frame);
            frame.updateId(this.client.getTarget().getTargetId());
            this.frameTree.addFrame(frame);
            frame.updateClient(client);
        }
        this.setupEventListeners(client);
        client.once(CDPSession.CDPSessionEvent.CDPSession_Disconnected, ignored -> {
            try {
                this.onClientDisconnect();
            }
            catch (Exception e) {
                LOGGER.error("onClientDisconnect error", (Throwable)e);
            }
        });
        this.initialize(client, frame);
        this.networkManager.addClient(client);
        if (frame != null) {
            frame.emit(Frame.FrameEvent.FrameSwappedByActivation, true);
        }
    }

    public void registerSpeculativeSession(CDPSession client) {
        this.networkManager.addClient(client);
    }

    private void setupEventListeners(CDPSession session) {
        session.on(CDPSession.CDPSessionEvent.Page_frameAttached, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameAttached(session, event.getFrameId(), event.getParentFrameId());
        });
        session.on(CDPSession.CDPSessionEvent.Page_frameNavigated, event -> {
            this.frameNavigatedReceived.add(event.getFrame().getId());
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameNavigated(event.getFrame(), event.getType());
        });
        session.on(CDPSession.CDPSessionEvent.Page_navigatedWithinDocument, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameNavigatedWithinDocument(event.getFrameId(), event.getUrl());
        });
        session.on(CDPSession.CDPSessionEvent.Page_frameDetached, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameDetached(event.getFrameId(), event.getReason());
        });
        session.on(CDPSession.CDPSessionEvent.Page_frameStartedLoading, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameStartedLoading(event.getFrameId());
        });
        session.on(CDPSession.CDPSessionEvent.Page_frameStoppedLoading, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onFrameStoppedLoading(event.getFrameId());
        });
        session.on(CDPSession.CDPSessionEvent.Runtime_executionContextCreated, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onExecutionContextCreated(event.getContext(), session);
        });
        session.on(CDPSession.CDPSessionEvent.Page_lifecycleEvent, event -> {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(AwaitableResult::waitingGetResult);
            this.onLifecycleEvent((LifecycleEvent)event);
        });
    }

    public CDPSession client() {
        return this.client;
    }

    public TimeoutSettings timeoutSettings() {
        return this.timeoutSettings;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public void initialize(CDPSession client, Frame frame) {
        try {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(handle -> handle.onSuccess(true));
            this.frameTreeHandled = AwaitableResult.create();
            this.networkManager.addClient(client);
            client.send("Page.enable");
            JsonNode result = client.send("Page.getFrameTree");
            FrameTreeEvent frameTree = (FrameTreeEvent)Constant.OBJECTMAPPER.treeToValue((TreeNode)result.get("frameTree"), FrameTreeEvent.class);
            this.handleFrameTree(client, frameTree);
            Optional.ofNullable(this.frameTreeHandled).ifPresent(handle -> handle.onSuccess(true));
            Map<String, Object> params = ParamsFactory.create();
            params.put("enabled", true);
            client.send("Page.setLifecycleEventsEnabled", params);
            client.send("Runtime.enable");
            this.createIsolatedWorld(client, UTILITY_WORLD_NAME);
            if (frame != null) {
                this.scriptsToEvaluateOnNewDocument.values().forEach(frame::addPreloadScript);
                for (Binding binding : this.bindings) {
                    frame.addExposedFunctionBinding(binding);
                }
            }
        }
        catch (Exception e) {
            Optional.ofNullable(this.frameTreeHandled).ifPresent(handle -> handle.onSuccess(true));
            if (e instanceof TargetCloseException) {
                return;
            }
            Helper.throwError(e);
        }
    }

    public Frame mainFrame() {
        Frame mainFrame = this.frameTree.getMainFrame();
        Objects.requireNonNull(mainFrame, "Requesting main frame too early!");
        return mainFrame;
    }

    public List<Frame> frames() {
        return new ArrayList<Frame>(this.frameTree.frames());
    }

    @Override
    public Frame frame(String frameId) {
        return this.frameTree.getById(frameId);
    }

    public void addExposedFunctionBinding(Binding binding) throws JsonProcessingException, EvaluateException {
        this.bindings.add(binding);
        for (Frame frame : this.frames()) {
            frame.addExposedFunctionBinding(binding);
        }
    }

    public void removeExposedFunctionBinding(Binding binding) throws JsonProcessingException, EvaluateException {
        this.bindings.remove(binding);
        for (Frame frame : this.frames()) {
            frame.removeExposedFunctionBinding(binding);
        }
    }

    public NewDocumentScriptEvaluation evaluateOnNewDocument(final String source) {
        JsonNode response = this.mainFrame().client().send("Page.addScriptToEvaluateOnNewDocument", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("source", source);
            }
        });
        String identifier = response.get("identifier").asText();
        PreloadScript preloadScript = new PreloadScript(this.mainFrame(), identifier, source);
        this.scriptsToEvaluateOnNewDocument.put(identifier, preloadScript);
        for (Frame frame : this.frames()) {
            frame.addPreloadScript(preloadScript);
        }
        return new NewDocumentScriptEvaluation(identifier);
    }

    public void removeScriptToEvaluateOnNewDocument(String identifier) {
        PreloadScript preloadScript = this.scriptsToEvaluateOnNewDocument.get(identifier);
        if (preloadScript == null) {
            throw new JvppeteerException("Script to evaluate on new document with id " + identifier + " not found");
        }
        this.scriptsToEvaluateOnNewDocument.remove(identifier);
        for (Frame frame : this.frames()) {
            final String identifier2 = preloadScript.getIdForFrame(frame);
            if (StringUtil.isEmpty(identifier2)) {
                return;
            }
            try {
                frame.client().send("Page.removeScriptToEvaluateOnNewDocument", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("identifier", identifier2);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Page.removeScriptToEvaluateOnNewDocument error", (Throwable)e);
            }
        }
    }

    public void onAttachedToTarget(Target target) {
        if (!"iframe".equals(target.getTargetInfo().getType())) {
            return;
        }
        Frame frame = this.frame(target.getTargetInfo().getTargetId());
        if (frame != null) {
            frame.updateClient(target.session());
        }
        this.setupEventListeners(target.session());
        this.initialize(target.session(), frame);
    }

    public DeviceRequestPromptManager deviceRequestPromptManager(CDPSession client) {
        DeviceRequestPromptManager manager = this.deviceRequestPromptManagerMap.get(client);
        if (manager == null) {
            manager = new DeviceRequestPromptManager(client, this.timeoutSettings);
            this.deviceRequestPromptManagerMap.put(client, manager);
        }
        return manager;
    }

    private void onLifecycleEvent(LifecycleEvent event) {
        Frame frame = this.frame(event.getFrameId());
        if (frame == null) {
            return;
        }
        frame.onLifecycleEvent(event.getLoaderId(), event.getName());
        this.emit(FrameManagerEvent.LifecycleEvent, frame);
        frame.emit(Frame.FrameEvent.LifecycleEvent, true);
    }

    private void onFrameStoppedLoading(String frameId) {
        Frame frame = this.frame(frameId);
        if (frame == null) {
            return;
        }
        frame.onLoadingStopped();
        this.emit(FrameManagerEvent.LifecycleEvent, frame);
        frame.emit(Frame.FrameEvent.LifecycleEvent, true);
    }

    private void onFrameStartedLoading(String frameId) {
        Frame frame = this.frame(frameId);
        if (frame == null) {
            return;
        }
        frame.onLoadingStarted();
    }

    private void handleFrameTree(CDPSession session, FrameTreeEvent frameTree) {
        if (StringUtil.isNotEmpty(frameTree.getFrame().getParentId())) {
            this.onFrameAttached(session, frameTree.getFrame().getId(), frameTree.getFrame().getParentId());
        }
        if (!this.frameNavigatedReceived.contains(frameTree.getFrame().getId())) {
            this.onFrameNavigated(frameTree.getFrame(), "Navigation");
        } else {
            this.frameNavigatedReceived.remove(frameTree.getFrame().getId());
        }
        if (ValidateUtil.isEmpty(frameTree.getChildFrames())) {
            return;
        }
        for (FrameTreeEvent child : frameTree.getChildFrames()) {
            this.handleFrameTree(session, child);
        }
    }

    private void onFrameAttached(CDPSession session, String frameId, String parentFrameId) {
        Frame frame = this.frame(frameId);
        if (frame != null) {
            if (session != null && frame.client() != this.client) {
                frame.updateClient(session);
            }
            return;
        }
        frame = new Frame(this, frameId, parentFrameId, session);
        this.frameTree.addFrame(frame);
        this.emit(FrameManagerEvent.FrameAttached, frame);
    }

    private void onFrameNavigated(FramePayload framePayload, String navigationType) {
        String frameId = framePayload.getId();
        boolean isMainFrame = StringUtil.isEmpty(framePayload.getParentId());
        Frame frame = this.frameTree.getById(frameId);
        if (frame != null && ValidateUtil.isNotEmpty(frame.childFrames())) {
            for (Frame childFrame : frame.childFrames()) {
                this.removeFramesRecursively(childFrame);
            }
        }
        if (isMainFrame) {
            if (frame != null) {
                this.frameTree.removeFrame(frame);
                frame.setId(frameId);
            } else {
                frame = new Frame(this, frameId, null, this.client);
            }
            this.frameTree.addFrame(frame);
        }
        frame = this.frameTree.waitForFrame(frameId);
        frame.navigated(framePayload);
        this.emit(FrameManagerEvent.FrameNavigated, frame);
        frame.emit(Frame.FrameEvent.FrameNavigated, navigationType);
    }

    private void createIsolatedWorld(CDPSession session, String name) {
        String key = session.id() + name;
        if (this.isolatedWorlds.contains(key)) {
            return;
        }
        this.isolatedWorlds.add(name);
        Map<String, Object> params = ParamsFactory.create();
        params.put("source", "//# sourceURL=pptr:internal");
        params.put("worldName", name);
        this.client.send("Page.addScriptToEvaluateOnNewDocument", params);
        this.frames().stream().filter(frame -> frame.client() == session).forEach(frame -> {
            try {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("frameId", frame.id());
                param.put("grantUniveralAccess", true);
                param.put("worldName", name);
                this.client.send("Page.createIsolatedWorld", param);
            }
            catch (Exception e) {
                LOGGER.error("Page.createIsolatedWorld error: ", (Throwable)e);
            }
        });
    }

    private void onFrameNavigatedWithinDocument(String frameId, String url) {
        Frame frame = this.frame(frameId);
        if (frame == null) {
            return;
        }
        frame.navigatedWithinDocument(url);
        this.emit(FrameManagerEvent.FrameNavigatedWithinDocument, frame);
        frame.emit(Frame.FrameEvent.FrameNavigatedWithinDocument, true);
        this.emit(FrameManagerEvent.FrameNavigated, frame);
        frame.emit(Frame.FrameEvent.FrameNavigated, "Navigation");
    }

    private void onFrameDetached(String frameId, String reason) {
        Frame frame = this.frame(frameId);
        if (frame == null) {
            return;
        }
        switch (reason) {
            case "remove": {
                this.removeFramesRecursively(frame);
                break;
            }
            case "swap": {
                this.emit(FrameManagerEvent.FrameSwapped, frame);
                frame.emit(Frame.FrameEvent.FrameSwapped, true);
            }
        }
    }

    private void onExecutionContextCreated(ExecutionContextDescription contextPayload, CDPSession session) {
        String frameId = contextPayload.getAuxData() != null ? contextPayload.getAuxData().getFrameId() : null;
        Frame frame = this.frame(frameId);
        IsolatedWorld world = null;
        if (frame != null) {
            if (frame.client() != session) {
                return;
            }
            if (contextPayload.getAuxData() != null && contextPayload.getAuxData().getIsDefault()) {
                world = frame.worlds().get("mainWorld");
            } else if (contextPayload.getName().startsWith(UTILITY_WORLD_NAME)) {
                world = frame.worlds().get("puppeteerWorld");
            }
        }
        if (world == null) {
            return;
        }
        CDPSession client = frame.client() != null ? frame.client() : this.client;
        ExecutionContext context = new ExecutionContext(client, contextPayload, world);
        world.setContext(context);
    }

    private void removeFramesRecursively(Frame childFrame) {
        if (ValidateUtil.isNotEmpty(childFrame.childFrames())) {
            for (Frame frame : childFrame.childFrames()) {
                this.removeFramesRecursively(frame);
            }
        }
        childFrame.dispose();
        this.frameTree.removeFrame(childFrame);
        this.emit(FrameManagerEvent.FrameDetached, childFrame);
        childFrame.emit(Frame.FrameEvent.FrameDetached, childFrame);
    }

    public FrameTree frameTree() {
        return this.frameTree;
    }

    public static enum FrameManagerEvent {
        FrameAttached("FrameManager.FrameAttached"),
        FrameNavigated("FrameManager.FrameNavigated"),
        FrameDetached("FrameManager.FrameDetached"),
        FrameSwapped("FrameManager.FrameSwapped"),
        LifecycleEvent("FrameManager.LifecycleEvent"),
        FrameNavigatedWithinDocument("FrameManager.FrameNavigatedWithinDocument"),
        ConsoleApiCalled("FrameManager.ConsoleApiCalled"),
        BindingCalled("FrameManager.BindingCalled");

        private String eventName;

        private FrameManagerEvent(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }
    }
}

