/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.core.BrowserContext;
import com.ruiyun.jvppeteer.core.ChromeTargetManager;
import com.ruiyun.jvppeteer.core.DevToolsTarget;
import com.ruiyun.jvppeteer.core.OtherTarget;
import com.ruiyun.jvppeteer.core.Page;
import com.ruiyun.jvppeteer.core.PageTarget;
import com.ruiyun.jvppeteer.core.Target;
import com.ruiyun.jvppeteer.core.TargetManager;
import com.ruiyun.jvppeteer.core.WorkerTarget;
import com.ruiyun.jvppeteer.entities.BrowserContextOptions;
import com.ruiyun.jvppeteer.entities.DebugInfo;
import com.ruiyun.jvppeteer.entities.GetVersionResponse;
import com.ruiyun.jvppeteer.entities.TargetInfo;
import com.ruiyun.jvppeteer.entities.TargetType;
import com.ruiyun.jvppeteer.entities.Viewport;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.transport.SessionFactory;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Browser
extends EventEmitter<BrowserEvent>
implements AutoCloseable {
    private final Viewport defaultViewport;
    private final Process process;
    private final Connection connection;
    private final Runnable closeCallback;
    private final Product product;
    private Function<Target, Boolean> isPageTargetCallback;
    private final BrowserContext defaultContext;
    private final Map<String, BrowserContext> contexts = new HashMap<String, BrowserContext>();
    private final TargetManager targetManager;
    private String executablePath;
    private List<String> defaultArgs;
    private final Consumer<Object> emitDisconnected = ignore -> this.emit(BrowserEvent.Disconnected, true);
    private final Consumer<Target> onAttachedToTarget = target -> {
        if (target.isTargetExposed() && target.initializedResult.waitingGetResult().equals((Object)Target.InitializationStatus.SUCCESS)) {
            this.emit(BrowserEvent.TargetCreated, target);
            target.browserContext().emit(BrowserContext.BrowserContextEvent.TargetCreated, target);
        }
    };
    private final Consumer<Target> onDetachedFromTarget = target -> {
        boolean initializedSuccess = target.initializedResult.waitingGetResult().equals((Object)Target.InitializationStatus.SUCCESS);
        target.setInitializedResult(Target.InitializationStatus.ABORTED);
        target.close();
        if (target.isTargetExposed() && initializedSuccess) {
            this.emit(BrowserEvent.TargetDestroyed, target);
            target.browserContext().emit(BrowserContext.BrowserContextEvent.TargetDestroyed, target);
        }
    };
    private final Consumer<Target> onTargetChanged = target -> {
        this.emit(BrowserEvent.TargetChanged, target);
        target.browserContext().emit(BrowserContext.BrowserContextEvent.TargetChanged, target);
    };
    private final Consumer<TargetInfo> onTargetDiscovered = target -> this.emit(BrowserEvent.TargetDiscovered, target);

    Browser(Product product, Connection connection, List<String> contextIds, Viewport viewport, Process process, Runnable closeCallback, Function<Target, Boolean> targetFilterCallback, Function<Target, Boolean> isPageTargetCallback, boolean waitForInitiallyDiscoveredTargets) {
        this.product = product;
        this.defaultViewport = viewport;
        this.process = process;
        this.connection = connection;
        if (closeCallback == null) {
            closeCallback = () -> {};
        }
        this.closeCallback = closeCallback;
        if (targetFilterCallback == null) {
            targetFilterCallback = ignore -> true;
        }
        Function<Target, Boolean> targetFilterCallback1 = targetFilterCallback;
        this.setIsPageTargetCallback(isPageTargetCallback);
        if (Product.FIREFOX.equals((Object)product)) {
            throw new JvppeteerException("Not Support firefox");
        }
        this.targetManager = new ChromeTargetManager(connection, this.createTarget(), targetFilterCallback1, waitForInitiallyDiscoveredTargets);
        this.defaultContext = new BrowserContext(connection, this, "");
        if (ValidateUtil.isNotEmpty(contextIds)) {
            for (String contextId : contextIds) {
                this.contexts.putIfAbsent(contextId, new BrowserContext(this.connection, this, contextId));
            }
        }
    }

    private void attach() {
        this.connection.on(CDPSession.CDPSessionEvent.CDPSession_Disconnected, this.emitDisconnected);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetAvailable, this.onAttachedToTarget);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetGone, this.onDetachedFromTarget);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetChanged, this.onTargetChanged);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetDiscovered, this.onTargetDiscovered);
        this.targetManager.initialize();
    }

    private void detach() {
        this.connection.off(CDPSession.CDPSessionEvent.CDPSession_Disconnected, this.emitDisconnected);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetAvailable, this.onAttachedToTarget);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetGone, this.onDetachedFromTarget);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetChanged, this.onTargetChanged);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetDiscovered, this.onTargetDiscovered);
    }

    public Process process() {
        return this.process;
    }

    public String executablePath() {
        return this.executablePath;
    }

    public TargetManager targetManager() {
        return this.targetManager;
    }

    private void setIsPageTargetCallback(Function<Target, Boolean> isPageTargetCallback) {
        if (isPageTargetCallback == null) {
            isPageTargetCallback = target -> TargetType.PAGE.equals((Object)target.type()) || TargetType.BACKGROUND_PAGE.equals((Object)target.type()) || TargetType.WEBVIEW.equals((Object)target.type());
        }
        this.isPageTargetCallback = isPageTargetCallback;
    }

    Function<Target, Boolean> getIsPageTargetCallback() {
        return this.isPageTargetCallback;
    }

    public BrowserContext createBrowserContext() {
        return this.createBrowserContext(new BrowserContextOptions());
    }

    public BrowserContext createBrowserContext(BrowserContextOptions options) {
        Map<String, Object> params = ParamsFactory.create();
        params.put("proxyServer", options.getProxyServer());
        if (ValidateUtil.isNotEmpty(options.getProxyBypassList())) {
            params.put("proxyBypassList", String.join((CharSequence)",", options.getProxyBypassList()));
        }
        JsonNode result = this.connection.send("Target.createBrowserContext", params);
        BrowserContext context = new BrowserContext(this.connection, this, result.get("browserContextId").asText());
        this.contexts.put(result.get("browserContextId").asText(), context);
        return context;
    }

    public List<BrowserContext> browserContexts() {
        ArrayList<BrowserContext> contexts = new ArrayList<BrowserContext>();
        contexts.add(this.defaultBrowserContext());
        contexts.addAll(this.contexts.values());
        return contexts;
    }

    public BrowserContext defaultBrowserContext() {
        return this.defaultContext;
    }

    void disposeContext(String contextId) {
        if (StringUtil.isEmpty(contextId)) {
            return;
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("browserContextId", contextId);
        this.connection.send("Target.disposeBrowserContext", params);
        this.contexts.remove(contextId);
    }

    public List<Page> pages() {
        return this.browserContexts().stream().flatMap(context -> context.pages().stream()).collect(Collectors.toList());
    }

    private TargetManager.TargetFactory createTarget() {
        return (targetInfo, session, parentSession) -> {
            String browserContextId = targetInfo.getBrowserContextId();
            BrowserContext context = StringUtil.isNotEmpty(browserContextId) && this.contexts.containsKey(browserContextId) ? this.contexts.get(browserContextId) : this.defaultContext;
            if (context == null) {
                throw new JvppeteerException("Missing browser context");
            }
            SessionFactory createSession = isAutoAttachEmulated -> this.connection._createSession(targetInfo, isAutoAttachEmulated);
            OtherTarget otherTarget = new OtherTarget(targetInfo, session, context, this.targetManager, createSession);
            if (StringUtil.isNotEmpty(targetInfo.getUrl()) && targetInfo.getUrl().startsWith("devtools://")) {
                return new DevToolsTarget(targetInfo, session, context, this.targetManager, createSession, this.defaultViewport);
            }
            if (this.isPageTargetCallback.apply(otherTarget).booleanValue()) {
                return new PageTarget(targetInfo, session, context, this.targetManager, createSession, this.defaultViewport);
            }
            if ("service_worker".equals(targetInfo.getType()) || "shared_worker".equals(targetInfo.getType())) {
                return new WorkerTarget(targetInfo, session, context, this.targetManager, createSession);
            }
            return otherTarget;
        };
    }

    public String wsEndpoint() {
        return this.connection.url();
    }

    public Page newPage() {
        return this.defaultContext.newPage();
    }

    public Page createPageInContext(String contextId) {
        JsonNode result;
        Map<String, Object> params = ParamsFactory.create();
        params.put("url", "about:blank");
        if (StringUtil.isNotEmpty(contextId)) {
            params.put("browserContextId", contextId);
        }
        if ((result = this.connection.send("Target.createTarget", params)) != null) {
            String targetId = result.get("targetId").asText();
            Target target = this.waitForTarget(t -> t.getTargetId().equals(targetId), 30000);
            if (target == null) {
                throw new JvppeteerException("Missing target for page (id = " + targetId + ")");
            }
            if (!target.initializedResult.waitingGetResult().equals((Object)Target.InitializationStatus.SUCCESS)) {
                throw new JvppeteerException("Failed to create target for page (id =" + targetId + ")");
            }
            Page page = target.page();
            if (page == null) {
                throw new JvppeteerException("Failed to create a page for context (id = " + contextId + ")");
            }
            return page;
        }
        throw new JvppeteerException("Failed to create target for page (id =" + contextId + ")");
    }

    public Target target() {
        for (Target target : this.targets()) {
            if (!TargetType.BROWSER.equals((Object)target.type())) continue;
            return target;
        }
        throw new JvppeteerException("Browser target is not found");
    }

    public List<Target> targets() {
        return this.targetManager.getAvailableTargets().values().stream().filter(target -> target.isTargetExposed() && target.initializedResult.waitingGetResult().equals((Object)Target.InitializationStatus.SUCCESS)).collect(Collectors.toList());
    }

    public String version() throws JsonProcessingException {
        GetVersionResponse version = this.getVersion();
        return version.getProduct();
    }

    public String userAgent() throws JsonProcessingException {
        GetVersionResponse version = this.getVersion();
        return version.getUserAgent();
    }

    @Override
    public void close() {
        this.closeCallback.run();
        this.disconnect();
    }

    public void disconnect() {
        this.targetManager.dispose();
        this.connection.dispose();
        this.detach();
    }

    public boolean connected() {
        return !this.connection.closed();
    }

    private GetVersionResponse getVersion() throws JsonProcessingException {
        return (GetVersionResponse)Constant.OBJECTMAPPER.treeToValue((TreeNode)this.connection.send("Browser.getVersion"), GetVersionResponse.class);
    }

    public DebugInfo debugInfo() {
        return new DebugInfo(this.connection.getPendingProtocolErrors());
    }

    public Target waitForTarget(Predicate<Target> predicate) {
        Supplier<Target> conditionChecker = () -> Helper.filter(this.targets(), predicate);
        return Helper.waitForCondition(conditionChecker, 30000L, "Waiting for target failed: timeout 30000ms exceeded");
    }

    public Target waitForTarget(Predicate<Target> predicate, int timeout) {
        Supplier<Target> conditionChecker = () -> Helper.filter(this.targets(), predicate);
        return Helper.waitForCondition(conditionChecker, timeout, "Waiting for target failed: timeout " + timeout + "ms exceeded");
    }

    public static Browser create(Product product, Connection connection, List<String> contextIds, boolean acceptInsecureCerts, Viewport defaultViewport, Process process, Runnable closeCallback, Function<Target, Boolean> targetFilterCallback, Function<Target, Boolean> IsPageTargetCallback, boolean waitForInitiallyDiscoveredTargets) {
        Browser browser = new Browser(product, connection, contextIds, defaultViewport, process, closeCallback, targetFilterCallback, IsPageTargetCallback, waitForInitiallyDiscoveredTargets);
        if (acceptInsecureCerts) {
            Map<String, Object> params = ParamsFactory.create();
            params.put("ignore", true);
            connection.send("Security.setIgnoreCertificateErrors", params);
        }
        browser.attach();
        return browser;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public List<String> defaultArgs() {
        return this.defaultArgs;
    }

    public void setDefaultArgs(List<String> defaultArgs) {
        this.defaultArgs = defaultArgs;
    }

    public Product product() {
        return this.product;
    }

    public static enum BrowserEvent {
        TargetCreated("targetcreated"),
        TargetDestroyed("targetdestroyed"),
        TargetChanged("targetchanged"),
        TargetDiscovered("targetdiscovered"),
        Disconnected("disconnected");

        private final String eventName;

        private BrowserEvent(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }
    }
}

