/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.common;

import com.ruiyun.jvppeteer.core.WaitTask;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskManager.class);
    private final Set<WaitTask> tasks = new HashSet<WaitTask>();

    public void add(WaitTask task) {
        this.tasks.add(task);
    }

    public void delete(WaitTask task) {
        this.tasks.remove(task);
    }

    public void terminateAll(JvppeteerException error) {
        this.tasks.forEach(task -> {
            try {
                task.terminate(error);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        });
        this.tasks.clear();
    }

    public void rerunAll() {
        this.tasks.forEach(task -> {
            try {
                task.rerun();
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        });
    }
}

