/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.common;

import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.entities.DeviceRequestPromptDevice;
import com.ruiyun.jvppeteer.events.DeviceRequestPromptedEvent;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

public class DeviceRequestPrompt {
    private CDPSession client;
    private final TimeoutSettings timeoutSettings;
    private final String id;
    private boolean handled;
    final Set<WaitForDevicePromise> waitForDevicePromises = new HashSet<WaitForDevicePromise>();
    final List<DeviceRequestPromptDevice> devices = new ArrayList<DeviceRequestPromptDevice>();
    private final Consumer<DeviceRequestPromptedEvent> updateDevicesHandle = this::updateDevicesHandle;

    public DeviceRequestPrompt(CDPSession client, TimeoutSettings timeoutSettings, DeviceRequestPromptedEvent firstEvent) {
        this.client = client;
        this.timeoutSettings = timeoutSettings;
        this.id = firstEvent.getId();
        this.client.on(CDPSession.CDPSessionEvent.DeviceAccess_deviceRequestPrompted, this.updateDevicesHandle);
        this.client.on(CDPSession.CDPSessionEvent.Target_detachedFromTarget, ignore -> {
            this.client = null;
        });
    }

    private void updateDevicesHandle(DeviceRequestPromptedEvent event) {
        if (!this.id.equals(event.getId())) {
            return;
        }
        for (DeviceRequestPromptDevice rawDevice : event.getDevices()) {
            if (this.devices.stream().anyMatch(device -> device.getId().equals(rawDevice.getId()))) continue;
            DeviceRequestPromptDevice newDevice = new DeviceRequestPromptDevice(rawDevice.getId(), rawDevice.getName());
            this.devices.add(newDevice);
            for (WaitForDevicePromise waitForDevicePromise : this.waitForDevicePromises) {
                if (!waitForDevicePromise.getFilter().apply(newDevice).booleanValue()) continue;
                waitForDevicePromise.getPromise().onSuccess(newDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceRequestPromptDevice waitForDevice(Function<DeviceRequestPromptDevice, Boolean> filter, Integer timeout) {
        for (DeviceRequestPromptDevice device : this.devices) {
            if (!filter.apply(device).booleanValue()) continue;
            return device;
        }
        if (timeout == null) {
            timeout = this.timeoutSettings.timeout();
        }
        AwaitableResult<DeviceRequestPromptDevice> waitableResult = AwaitableResult.create();
        WaitForDevicePromise handle = new WaitForDevicePromise(filter, waitableResult);
        this.waitForDevicePromises.add(handle);
        try {
            DeviceRequestPromptDevice deviceRequestPromptDevice = waitableResult.waitingGetResult(timeout, TimeUnit.MILLISECONDS);
            return deviceRequestPromptDevice;
        }
        finally {
            this.waitForDevicePromises.remove(handle);
        }
    }

    public void select(final DeviceRequestPromptDevice device) {
        Objects.requireNonNull(this.client, "Cannot select device through detached session!");
        ValidateUtil.assertArg(this.devices.contains(device), "Cannot select unknown device!");
        ValidateUtil.assertArg(!this.handled, "Cannot select DeviceRequestPrompt which is already handled!");
        this.client.off(CDPSession.CDPSessionEvent.DeviceAccess_deviceRequestPrompted, this.updateDevicesHandle);
        this.handled = true;
        this.client.send("DeviceAccess.selectPrompt", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("id", DeviceRequestPrompt.this.id);
                this.put("deviceId", device.getId());
            }
        });
    }

    public void cancel() {
        Objects.requireNonNull(this.client, "Cannot cancel prompt through detached session!");
        ValidateUtil.assertArg(!this.handled, "Cannot cancel DeviceRequestPrompt which is already handled!");
        this.client.off(CDPSession.CDPSessionEvent.DeviceAccess_deviceRequestPrompted, this.updateDevicesHandle);
        this.handled = true;
        this.client.send("DeviceAccess.cancelPrompt", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("id", DeviceRequestPrompt.this.id);
            }
        });
    }

    public static class WaitForDevicePromise {
        private Function<DeviceRequestPromptDevice, Boolean> filter;
        private AwaitableResult<DeviceRequestPromptDevice> promise;

        public WaitForDevicePromise() {
        }

        public WaitForDevicePromise(Function<DeviceRequestPromptDevice, Boolean> function, AwaitableResult<DeviceRequestPromptDevice> promise) {
            this.filter = function;
            this.promise = promise;
        }

        public Function<DeviceRequestPromptDevice, Boolean> getFilter() {
            return this.filter;
        }

        public void setFilter(Function<DeviceRequestPromptDevice, Boolean> filter) {
            this.filter = filter;
        }

        public AwaitableResult<DeviceRequestPromptDevice> getPromise() {
            return this.promise;
        }

        public void setPromise(AwaitableResult<DeviceRequestPromptDevice> promise) {
            this.promise = promise;
        }
    }
}

