/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ruiyun.jvppeteer.common.WebPermission;
import com.ruiyun.jvppeteer.entities.DragInterceptedEvent;
import com.ruiyun.jvppeteer.events.AttachedToTargetEvent;
import com.ruiyun.jvppeteer.events.AuthRequiredEvent;
import com.ruiyun.jvppeteer.events.BindingCalledEvent;
import com.ruiyun.jvppeteer.events.ConsoleAPICalledEvent;
import com.ruiyun.jvppeteer.events.DetachedFromTargetEvent;
import com.ruiyun.jvppeteer.events.EntryAddedEvent;
import com.ruiyun.jvppeteer.events.ExceptionThrownEvent;
import com.ruiyun.jvppeteer.events.ExecutionContextCreatedEvent;
import com.ruiyun.jvppeteer.events.ExecutionContextDestroyedEvent;
import com.ruiyun.jvppeteer.events.FileChooserOpenedEvent;
import com.ruiyun.jvppeteer.events.FrameAttachedEvent;
import com.ruiyun.jvppeteer.events.FrameDetachedEvent;
import com.ruiyun.jvppeteer.events.FrameNavigatedEvent;
import com.ruiyun.jvppeteer.events.FrameStartedLoadingEvent;
import com.ruiyun.jvppeteer.events.FrameStoppedLoadingEvent;
import com.ruiyun.jvppeteer.events.JavascriptDialogOpeningEvent;
import com.ruiyun.jvppeteer.events.LifecycleEvent;
import com.ruiyun.jvppeteer.events.LoadingFailedEvent;
import com.ruiyun.jvppeteer.events.LoadingFinishedEvent;
import com.ruiyun.jvppeteer.events.MetricsEvent;
import com.ruiyun.jvppeteer.events.NavigatedWithinDocumentEvent;
import com.ruiyun.jvppeteer.events.RequestPausedEvent;
import com.ruiyun.jvppeteer.events.RequestServedFromCacheEvent;
import com.ruiyun.jvppeteer.events.RequestWillBeSentEvent;
import com.ruiyun.jvppeteer.events.ResponseReceivedEvent;
import com.ruiyun.jvppeteer.events.ResponseReceivedExtraInfoEvent;
import com.ruiyun.jvppeteer.events.ScreencastFrameEvent;
import com.ruiyun.jvppeteer.events.ScriptParsedEvent;
import com.ruiyun.jvppeteer.events.StyleSheetAddedEvent;
import com.ruiyun.jvppeteer.events.TargetCreatedEvent;
import com.ruiyun.jvppeteer.events.TargetDestroyedEvent;
import com.ruiyun.jvppeteer.events.TargetInfoChangedEvent;
import com.ruiyun.jvppeteer.events.TracingCompleteEvent;
import com.ruiyun.jvppeteer.transport.CDPSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public interface Constant {
    public static final String VERSION = "128.0.6613.137";
    public static final String PROFILE_PREFIX = "jvppeteer_dev_chrome_profile-";
    public static final String[] PRODUCT_ENV = new String[]{"JVPPETEER_PRODUCT", "java_config_jvppeteer_product", "java_package_config_jvppeteer_product"};
    public static final String[] EXECUTABLE_ENV = new String[]{"JVPPETEER_EXECUTABLE_PATH", "java_config_jvppeteer_executable_path", "java_package_config_jvppeteer_executable_path"};
    public static final String JVPPETEER_CHROMIUM_REVISION_ENV = "JVPPETEER_CHROMIUM_REVISION";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final String SHELLS_PREFIX = "jvppeteer_browser_install_shells-";
    public static final String INSTALL_CHROME_FOR_TESTING_LINUX = "install-chrome-for-testing-linux.sh";
    public static final String INSTALL_CHROME_FOR_TESTING_WIN = "install-chrome-for-testing-win.ps1";
    public static final String INSTALL_CHROME_FOR_TESTING_MAC = "install-chrome-for-testing-mac.sh";
    public static final Pattern SOURCE_URL_REGEX = Pattern.compile("^[\\040\\t]*//[@#] sourceURL=\\s*(\\S*?)\\s*$", 8);
    public static final String[] PROBABLE_CHROME_EXECUTABLE_PATH = new String[]{"/opt/google/chrome/chrome", "/opt/google/chrome-beta/chrome", "/opt/google/chrome-unstable/chrome", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "/Applications/Google Chrome Beta.app/Contents/MacOS/Google Chrome Beta", "/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary", "/Applications/Google Chrome Dev.app/Contents/MacOS/Google Chrome Dev", "C:/Program Files (x86)/Google/Chrome/Application/chrome.exe", "C:/Program Files/Google/Chrome/Application/chrome.exe", "C:/Program Files (x86)/Google/Chrome Beta/Application/chrome.exe", "C:/Program Files/Google/Chrome Beta/Application/chrome.exe", "C:/Program Files (x86)/Google/Chrome SxS/Application/chrome.exe", "C:/Program Files/Google/Chrome SxS/Application/chrome.exe", "C:/Program Files (x86)/Google/Chrome Dev/Application/chrome.exe", "C:/Program Files/Google/Chrome Dev/Application/chrome.exe"};
    public static final List<String> DEFAULT_ARGS = Collections.unmodifiableList(new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.addAll(Arrays.asList("--allow-pre-commit-input", "--disable-background-networking", "--disable-background-timer-throttling", "--disable-backgrounding-occluded-windows", "--disable-breakpad", "--disable-client-side-phishing-detection", "--disable-component-extensions-with-background-pages", "--disable-component-update", "--disable-default-apps", "--disable-dev-shm-usage", "--disable-extensions", "--disable-hang-monitor", "--disable-infobars", "--disable-ipc-flooding-protection", "--disable-popup-blocking", "--disable-prompt-on-repost", "--disable-renderer-backgrounding", "--disable-search-engine-choice-screen", "--disable-sync", "--enable-automation", "--export-tagged-pdf", "--generate-pdf-document-outline", "--force-color-profile=srgb", "--metrics-recording-only", "--no-first-run", "--password-store=basic", "--use-mock-keychain"));
        }
    });
    public static final Set<String> supportedMetrics = new HashSet<String>(){
        private static final long serialVersionUID = -5224857570151968464L;
        {
            this.add("Timestamp");
            this.add("Documents");
            this.add("Frames");
            this.add("JSEventListeners");
            this.add("Nodes");
            this.add("LayoutCount");
            this.add("RecalcStyleCount");
            this.add("LayoutDuration");
            this.add("RecalcStyleDuration");
            this.add("ScriptDuration");
            this.add("TaskDuration");
            this.add("JSHeapUsedSize");
            this.add("JSHeapTotalSize");
        }
    };
    public static final int NETWORK_IDLE_TIME = 500;
    public static final ObjectMapper OBJECTMAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    public static final String METHOD = "method";
    public static final String PARAMS = "params";
    public static final String ID = "id";
    public static final String RESULT = "result";
    public static final String SESSION_ID = "sessionId";
    public static final String TARGET_INFO = "targetInfo";
    public static final String TYPE = "type";
    public static final String ERROR = "error";
    public static final String MESSAGE = "message";
    public static final String DATA = "data";
    public static final String TARGET_ID = "targetId";
    public static final String STREAM = "stream";
    public static final String EOF = "eof";
    public static final String BASE_64_ENCODED = "base64Encoded";
    public static final String CODE = "code";
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final Set<String> DEFAULTCATEGORIES = new LinkedHashSet<String>(){
        private static final long serialVersionUID = -5224857570151968464L;
        {
            this.add("-*");
            this.add("devtools.timeline");
            this.add("v8.execute");
            this.add("disabled-by-default-devtools.timeline");
            this.add("disabled-by-default-devtools.timeline.frame");
            this.add("toplevel");
            this.add("blink.console");
            this.add("blink.user_timing");
            this.add("latencyInfo");
            this.add("disabled-by-default-devtools.timeline.stack");
            this.add("disabled-by-default-v8.cpu_profiler");
        }
    };
    public static final String CDP_BINDING_PREFIX = "puppeteer_";
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final int TIME_FOR_WAITING_FOR_SWAP = 100;
    public static final String MAIN_WORLD = "mainWorld";
    public static final String PUPPETEER_WORLD = "puppeteerWorld";
    public static final String INTERNAL_URL = "pptr:internal";
    public static final String ABOUT_BLANK = "about:blank";
    public static final String JV_EMIT_EVENT_THREAD = "JvEmitEventThread-";
    public static final String JV_HANDLE_MESSAGE_THREAD = "JvHandleMessageThread-";
    public static final Map<String, Class<?>> LISTENNER_CLASSES = new HashMap<String, Class<?>>(){
        {
            block77: for (CDPSession.CDPSessionEvent event : CDPSession.CDPSessionEvent.values()) {
                switch (event.getEventName()) {
                    case "CDPSession.Disconnected": {
                        this.put(event.getEventName(), null);
                        continue block77;
                    }
                    case "sessionattached": 
                    case "sessionDetached": {
                        this.put(event.getEventName(), CDPSession.class);
                        continue block77;
                    }
                    case "Target.targetCreated": {
                        this.put(event.getEventName(), TargetCreatedEvent.class);
                        continue block77;
                    }
                    case "Target.targetDestroyed": {
                        this.put(event.getEventName(), TargetDestroyedEvent.class);
                        continue block77;
                    }
                    case "Target.targetInfoChanged": {
                        this.put(event.getEventName(), TargetInfoChangedEvent.class);
                        continue block77;
                    }
                    case "Target.attachedToTarget": {
                        this.put(event.getEventName(), AttachedToTargetEvent.class);
                        continue block77;
                    }
                    case "Target.detachedFromTarget": {
                        this.put(event.getEventName(), DetachedFromTargetEvent.class);
                        continue block77;
                    }
                    case "Page.javascriptDialogOpening": {
                        this.put(event.getEventName(), JavascriptDialogOpeningEvent.class);
                        continue block77;
                    }
                    case "Page.screencastFrame": {
                        this.put(event.getEventName(), ScreencastFrameEvent.class);
                        continue block77;
                    }
                    case "Runtime.exceptionThrown": {
                        this.put(event.getEventName(), ExceptionThrownEvent.class);
                        continue block77;
                    }
                    case "Performance.metrics": {
                        this.put(event.getEventName(), MetricsEvent.class);
                        continue block77;
                    }
                    case "Log.entryAdded": {
                        this.put(event.getEventName(), EntryAddedEvent.class);
                        continue block77;
                    }
                    case "Page.fileChooserOpened": {
                        this.put(event.getEventName(), FileChooserOpenedEvent.class);
                        continue block77;
                    }
                    case "Debugger.scriptParsed": {
                        this.put(event.getEventName(), ScriptParsedEvent.class);
                        continue block77;
                    }
                    case "Runtime.executionContextCreated": {
                        this.put(event.getEventName(), ExecutionContextCreatedEvent.class);
                        continue block77;
                    }
                    case "Runtime.executionContextDestroyed": {
                        this.put(event.getEventName(), ExecutionContextDestroyedEvent.class);
                        continue block77;
                    }
                    case "CSS.styleSheetAdded": {
                        this.put(event.getEventName(), StyleSheetAddedEvent.class);
                        continue block77;
                    }
                    case "Page.frameAttached": {
                        this.put(event.getEventName(), FrameAttachedEvent.class);
                        continue block77;
                    }
                    case "Page.frameNavigated": {
                        this.put(event.getEventName(), FrameNavigatedEvent.class);
                        continue block77;
                    }
                    case "Page.navigatedWithinDocument": {
                        this.put(event.getEventName(), NavigatedWithinDocumentEvent.class);
                        continue block77;
                    }
                    case "Page.frameDetached": {
                        this.put(event.getEventName(), FrameDetachedEvent.class);
                        continue block77;
                    }
                    case "Page.frameStoppedLoading": {
                        this.put(event.getEventName(), FrameStoppedLoadingEvent.class);
                        continue block77;
                    }
                    case "Page.lifecycleEvent": {
                        this.put(event.getEventName(), LifecycleEvent.class);
                        continue block77;
                    }
                    case "Fetch.requestPaused": {
                        this.put(event.getEventName(), RequestPausedEvent.class);
                        continue block77;
                    }
                    case "Fetch.authRequired": {
                        this.put(event.getEventName(), AuthRequiredEvent.class);
                        continue block77;
                    }
                    case "Network.requestWillBeSent": {
                        this.put(event.getEventName(), RequestWillBeSentEvent.class);
                        continue block77;
                    }
                    case "Network.requestServedFromCache": {
                        this.put(event.getEventName(), RequestServedFromCacheEvent.class);
                        continue block77;
                    }
                    case "Network.responseReceived": {
                        this.put(event.getEventName(), ResponseReceivedEvent.class);
                        continue block77;
                    }
                    case "Network.loadingFinished": {
                        this.put(event.getEventName(), LoadingFinishedEvent.class);
                        continue block77;
                    }
                    case "Network.loadingFailed": {
                        this.put(event.getEventName(), LoadingFailedEvent.class);
                        continue block77;
                    }
                    case "Runtime.consoleAPICalled": {
                        this.put(event.getEventName(), ConsoleAPICalledEvent.class);
                        continue block77;
                    }
                    case "Runtime.bindingCalled": {
                        this.put(event.getEventName(), BindingCalledEvent.class);
                        continue block77;
                    }
                    case "Tracing.tracingComplete": {
                        this.put(event.getEventName(), TracingCompleteEvent.class);
                        continue block77;
                    }
                    case "Page.frameStartedLoading": {
                        this.put(event.getEventName(), FrameStartedLoadingEvent.class);
                        continue block77;
                    }
                    case "Network.responseReceivedExtraInfo": {
                        this.put(event.getEventName(), ResponseReceivedExtraInfoEvent.class);
                        continue block77;
                    }
                    case "Input.dragIntercepted": {
                        this.put(event.getEventName(), DragInterceptedEvent.class);
                    }
                }
            }
        }
    };
    public static final Map<Integer, String> CLOSE_REASON = new HashMap<Integer, String>(){
        {
            this.put(1000, "Normal closure");
            this.put(1001, "Endpoint is leaving, possibly due to a server error or because the browser is navigating away from the page with the open connection");
            this.put(1002, "Connection closed due to a protocol error");
            this.put(1003, "Connection closed due to receiving an unsupported data type (e.g., a text-only endpoint received binary data)");
            this.put(1005, "An expected status code was not received");
            this.put(1006, "Connection is abnormally closed without sending a close frame when expecting a status code");
            this.put(1007, "Connection closed due to receiving data in an invalid format (e.g., non-UTF-8 data in a text message)");
            this.put(1008, "Connection closed due to receiving data that violates the policy. This is a generic status code used when 1003 and 1009 are not applicable");
            this.put(1009, "Connection closed due to receiving a too large data frame");
            this.put(1010, "Client expects the server to negotiate one or more extensions, but the server did not handle them, so the client closes the connection");
            this.put(1011, "Server closes the connection because the client encountered an unexpected situation preventing it from completing the request");
            this.put(1012, "Server closes the connection due to a restart. This is a generic status code used when 1001 is not applicable");
            this.put(1013, "Server closes the connection for temporary reasons, such as server overload leading to closing some client connections");
            this.put(1015, "Connection was closed because the TLS handshake could not be completed");
            this.put(-1, "Connection has not yet been opened");
            this.put(-2, "Connection was closed due to an internal error");
            this.put(-3, "Connection was closed due to failing to complete the Flash policy check");
        }
    };
    public static final Map<WebPermission, String> WEB_PERMISSION_TO_PROTOCOL_PERMISSION = new HashMap<WebPermission, String>(32){
        {
            this.put(WebPermission.GEOLOCATION, "geolocation");
            this.put(WebPermission.MIDI, "midi");
            this.put(WebPermission.NOTIFICATIONS, "notifications");
            this.put(WebPermission.CAMERA, "videoCapture");
            this.put(WebPermission.MICROPHONE, "audioCapture");
            this.put(WebPermission.BACKGROUND_SYNC, "backgroundSync");
            this.put(WebPermission.AMBIENT_LIGHT_SENSOR, "sensors");
            this.put(WebPermission.ACCELEROMETER, "sensors");
            this.put(WebPermission.GYROSCOPE, "sensors");
            this.put(WebPermission.MAGNETOMETER, "sensors");
            this.put(WebPermission.ACCESSIBILITY_EVENTS, "accessibilityEvents");
            this.put(WebPermission.CLIPBOARD_READ, "clipboardReadWrite");
            this.put(WebPermission.CLIPBOARD_WRITE, "clipboardReadWrite");
            this.put(WebPermission.CLIPBOARD_SANITIZED_WRITE, "clipboardSanitizedWrite");
            this.put(WebPermission.PAYMENT_HANDLER, "paymentHandler");
            this.put(WebPermission.PERSISTENT_STORAGE, "durableStorage");
            this.put(WebPermission.IDLE_DETECTION, "idleDetection");
            this.put(WebPermission.MIDI_SYSEX, "midiSysex");
        }
    };
}

