/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.browser;

import com.ruiyun.jvppeteer.core.browser.Browser;
import com.ruiyun.jvppeteer.core.page.Page;
import com.ruiyun.jvppeteer.core.page.Target;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.events.EventHandler;
import com.ruiyun.jvppeteer.events.Events;
import com.ruiyun.jvppeteer.options.ChromeArgOptions;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BrowserContext
extends EventEmitter {
    private Connection connection;
    private Browser browser;
    private String id;
    private static final Map<String, String> webPermissionToProtocol = new HashMap<String, String>(32);

    public BrowserContext() {
    }

    public BrowserContext(Connection connection, Browser browser, String contextId) {
        this.connection = connection;
        this.browser = browser;
        this.id = contextId;
    }

    public void onTargetchanged(EventHandler<Target> handler) {
        this.on(Events.BROWSERCONTEXT_TARGETCHANGED.getName(), handler);
    }

    public void onTrgetcreated(EventHandler<Target> handler) {
        this.on(Events.BROWSERCONTEXT_TARGETCREATED.getName(), handler);
    }

    public void clearPermissionOverrides() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("browserContextId", this.id);
        this.connection.send("Browser.resetPermissions", params, true);
    }

    public void close() {
        ValidateUtil.assertArg(StringUtil.isNotEmpty(this.id), "Non-incognito profiles cannot be closed!");
        this.browser.disposeContext(this.id);
    }

    public boolean isIncognito() {
        return StringUtil.isNotEmpty(this.id);
    }

    public void overridePermissions(String origin, List<String> permissions) {
        permissions.replaceAll(item -> {
            String protocolPermission = webPermissionToProtocol.get(item);
            ValidateUtil.assertArg(protocolPermission != null, "Unknown permission: " + item);
            return protocolPermission;
        });
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("origin", origin);
        params.put("browserContextId", this.id);
        params.put("permissions", permissions);
        this.connection.send("Browser.grantPermissions", params, true);
    }

    public List<Page> pages() {
        return this.targets().stream().filter(target -> "page".equals(target.type())).map(Target::page).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Target> targets() {
        return this.browser.targets().stream().filter(target -> target.browserContext() == this).collect(Collectors.toList());
    }

    public Target waitForTarget(Predicate<Target> predicate, ChromeArgOptions options) {
        return this.browser.waitForTarget(target -> target.browserContext() == this && predicate.test((Target)target), options);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Browser browser() {
        return this.browser;
    }

    public Page newPage() {
        return this.browser.createPageInContext(this.id);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    static {
        webPermissionToProtocol.put("geolocation", "geolocation");
        webPermissionToProtocol.put("midi", "midi");
        webPermissionToProtocol.put("notifications", "notifications");
        webPermissionToProtocol.put("push", "push");
        webPermissionToProtocol.put("camera", "videoCapture");
        webPermissionToProtocol.put("microphone", "audioCapture");
        webPermissionToProtocol.put("background-sync", "backgroundSync");
        webPermissionToProtocol.put("ambient-light-sensor", "sensors");
        webPermissionToProtocol.put("accelerometer", "sensors");
        webPermissionToProtocol.put("gyroscope", "sensors");
        webPermissionToProtocol.put("magnetometer", "sensors");
        webPermissionToProtocol.put("accessibility-events", "accessibilityEvents");
        webPermissionToProtocol.put("clipboard-read", "clipboardRead");
        webPermissionToProtocol.put("payment-handler", "paymentHandler");
        webPermissionToProtocol.put("midi-sysex", "midiSysex");
    }
}

