/*
 * Decompiled with CFR 0.152.
 */
package me.everything.android.ui.overscroll;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.util.Log;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import me.everything.android.ui.overscroll.IOverScrollDecor;
import me.everything.android.ui.overscroll.IOverScrollStateListener;
import me.everything.android.ui.overscroll.IOverScrollUpdateListener;
import me.everything.android.ui.overscroll.ListenerStubs;
import me.everything.android.ui.overscroll.adapters.IOverScrollDecoratorAdapter;

public abstract class OverScrollBounceEffectDecoratorBase
implements IOverScrollDecor,
View.OnTouchListener {
    public static final String TAG = "OverScrollDecor";
    public static final float DEFAULT_TOUCH_DRAG_MOVE_RATIO_FWD = 3.0f;
    public static final float DEFAULT_TOUCH_DRAG_MOVE_RATIO_BCK = 1.0f;
    public static final float DEFAULT_DECELERATE_FACTOR = -2.0f;
    protected static final int MAX_BOUNCE_BACK_DURATION_MS = 800;
    protected static final int MIN_BOUNCE_BACK_DURATION_MS = 200;
    protected final OverScrollStartAttributes mStartAttr = new OverScrollStartAttributes();
    protected final IOverScrollDecoratorAdapter mViewAdapter;
    protected final IdleState mIdleState;
    protected final OverScrollingState mOverScrollingState;
    protected final BounceBackState mBounceBackState;
    protected IDecoratorState mCurrentState;
    protected IOverScrollStateListener mStateListener = new ListenerStubs.OverScrollStateListenerStub();
    protected IOverScrollUpdateListener mUpdateListener = new ListenerStubs.OverScrollUpdateListenerStub();
    protected float mVelocity;

    public OverScrollBounceEffectDecoratorBase(IOverScrollDecoratorAdapter viewAdapter, float decelerateFactor, float touchDragRatioFwd, float touchDragRatioBck) {
        this.mViewAdapter = viewAdapter;
        this.mBounceBackState = new BounceBackState(decelerateFactor);
        this.mOverScrollingState = new OverScrollingState(touchDragRatioFwd, touchDragRatioBck);
        this.mIdleState = new IdleState();
        this.mCurrentState = this.mIdleState;
        this.attach();
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 2: {
                return this.mCurrentState.handleMoveTouchEvent(event);
            }
            case 1: 
            case 3: {
                return this.mCurrentState.handleUpOrCancelTouchEvent(event);
            }
        }
        return false;
    }

    @Override
    public void setOverScrollStateListener(IOverScrollStateListener listener) {
        this.mStateListener = listener != null ? listener : new ListenerStubs.OverScrollStateListenerStub();
    }

    @Override
    public void setOverScrollUpdateListener(IOverScrollUpdateListener listener) {
        this.mUpdateListener = listener != null ? listener : new ListenerStubs.OverScrollUpdateListenerStub();
    }

    @Override
    public int getCurrentState() {
        return this.mCurrentState.getStateId();
    }

    @Override
    public View getView() {
        return this.mViewAdapter.getView();
    }

    protected void issueStateTransition(IDecoratorState state) {
        IDecoratorState oldState = this.mCurrentState;
        this.mCurrentState = state;
        this.mCurrentState.handleEntryTransition(oldState);
    }

    protected void attach() {
        this.getView().setOnTouchListener((View.OnTouchListener)this);
        this.getView().setOverScrollMode(2);
    }

    @Override
    public void detach() {
        if (this.mCurrentState != this.mIdleState) {
            Log.w((String)TAG, (String)"Decorator detached while over-scroll is in effect. You might want to add a precondition of that getCurrentState()==STATE_IDLE, first.");
        }
        this.getView().setOnTouchListener(null);
        this.getView().setOverScrollMode(0);
    }

    protected abstract MotionAttributes createMotionAttributes();

    protected abstract AnimationAttributes createAnimationAttributes();

    protected abstract void translateView(View var1, float var2);

    protected abstract void translateViewAndEvent(View var1, float var2, MotionEvent var3);

    protected class BounceBackState
    implements IDecoratorState,
    Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        protected final Interpolator mBounceBackInterpolator = new DecelerateInterpolator();
        protected final float mDecelerateFactor;
        protected final float mDoubleDecelerateFactor;
        protected final AnimationAttributes mAnimAttributes;

        public BounceBackState(float decelerateFactor) {
            this.mDecelerateFactor = decelerateFactor;
            this.mDoubleDecelerateFactor = 2.0f * decelerateFactor;
            this.mAnimAttributes = OverScrollBounceEffectDecoratorBase.this.createAnimationAttributes();
        }

        @Override
        public int getStateId() {
            return 3;
        }

        @Override
        public void handleEntryTransition(IDecoratorState fromState) {
            OverScrollBounceEffectDecoratorBase.this.mStateListener.onOverScrollStateChange(OverScrollBounceEffectDecoratorBase.this, fromState.getStateId(), this.getStateId());
            Animator bounceBackAnim = this.createAnimator();
            bounceBackAnim.addListener((Animator.AnimatorListener)this);
            bounceBackAnim.start();
        }

        @Override
        public boolean handleMoveTouchEvent(MotionEvent event) {
            return true;
        }

        @Override
        public boolean handleUpOrCancelTouchEvent(MotionEvent event) {
            return true;
        }

        public void onAnimationEnd(Animator animation) {
            OverScrollBounceEffectDecoratorBase.this.issueStateTransition(OverScrollBounceEffectDecoratorBase.this.mIdleState);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            OverScrollBounceEffectDecoratorBase.this.mUpdateListener.onOverScrollUpdate(OverScrollBounceEffectDecoratorBase.this, 3, ((Float)animation.getAnimatedValue()).floatValue());
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }

        protected Animator createAnimator() {
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            this.mAnimAttributes.init(view);
            if (OverScrollBounceEffectDecoratorBase.this.mVelocity == 0.0f || OverScrollBounceEffectDecoratorBase.this.mVelocity < 0.0f && OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir || OverScrollBounceEffectDecoratorBase.this.mVelocity > 0.0f && !OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir) {
                return this.createBounceBackAnimator(this.mAnimAttributes.mAbsOffset);
            }
            float slowdownDuration = -OverScrollBounceEffectDecoratorBase.this.mVelocity / this.mDecelerateFactor;
            slowdownDuration = slowdownDuration < 0.0f ? 0.0f : slowdownDuration;
            float slowdownDistance = -OverScrollBounceEffectDecoratorBase.this.mVelocity * OverScrollBounceEffectDecoratorBase.this.mVelocity / this.mDoubleDecelerateFactor;
            float slowdownEndOffset = this.mAnimAttributes.mAbsOffset + slowdownDistance;
            ObjectAnimator slowdownAnim = this.createSlowdownAnimator(view, (int)slowdownDuration, slowdownEndOffset);
            ObjectAnimator bounceBackAnim = this.createBounceBackAnimator(slowdownEndOffset);
            AnimatorSet wholeAnim = new AnimatorSet();
            wholeAnim.playSequentially(new Animator[]{slowdownAnim, bounceBackAnim});
            return wholeAnim;
        }

        protected ObjectAnimator createSlowdownAnimator(View view, int slowdownDuration, float slowdownEndOffset) {
            ObjectAnimator slowdownAnim = ObjectAnimator.ofFloat((Object)view, this.mAnimAttributes.mProperty, (float[])new float[]{slowdownEndOffset});
            slowdownAnim.setDuration((long)slowdownDuration);
            slowdownAnim.setInterpolator((TimeInterpolator)this.mBounceBackInterpolator);
            slowdownAnim.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            return slowdownAnim;
        }

        protected ObjectAnimator createBounceBackAnimator(float startOffset) {
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            float bounceBackDuration = Math.abs(startOffset) / this.mAnimAttributes.mMaxOffset * 800.0f;
            ObjectAnimator bounceBackAnim = ObjectAnimator.ofFloat((Object)view, this.mAnimAttributes.mProperty, (float[])new float[]{OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset});
            bounceBackAnim.setDuration((long)Math.max((int)bounceBackDuration, 200));
            bounceBackAnim.setInterpolator((TimeInterpolator)this.mBounceBackInterpolator);
            bounceBackAnim.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            return bounceBackAnim;
        }
    }

    protected class OverScrollingState
    implements IDecoratorState {
        protected final float mTouchDragRatioFwd;
        protected final float mTouchDragRatioBck;
        final MotionAttributes mMoveAttr;
        int mCurrDragState;

        public OverScrollingState(float touchDragRatioFwd, float touchDragRatioBck) {
            this.mMoveAttr = OverScrollBounceEffectDecoratorBase.this.createMotionAttributes();
            this.mTouchDragRatioFwd = touchDragRatioFwd;
            this.mTouchDragRatioBck = touchDragRatioBck;
        }

        @Override
        public int getStateId() {
            return this.mCurrDragState;
        }

        @Override
        public boolean handleMoveTouchEvent(MotionEvent event) {
            long dt;
            if (OverScrollBounceEffectDecoratorBase.this.mStartAttr.mPointerId != event.getPointerId(0)) {
                OverScrollBounceEffectDecoratorBase.this.issueStateTransition(OverScrollBounceEffectDecoratorBase.this.mBounceBackState);
                return true;
            }
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            if (!this.mMoveAttr.init(view, event)) {
                return true;
            }
            float deltaOffset = this.mMoveAttr.mDeltaOffset / (this.mMoveAttr.mDir == OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir ? this.mTouchDragRatioFwd : this.mTouchDragRatioBck);
            float newOffset = this.mMoveAttr.mAbsOffset + deltaOffset;
            if (OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir && !this.mMoveAttr.mDir && newOffset <= OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset || !OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir && this.mMoveAttr.mDir && newOffset >= OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset) {
                OverScrollBounceEffectDecoratorBase.this.translateViewAndEvent(view, OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset, event);
                OverScrollBounceEffectDecoratorBase.this.mUpdateListener.onOverScrollUpdate(OverScrollBounceEffectDecoratorBase.this, this.mCurrDragState, 0.0f);
                OverScrollBounceEffectDecoratorBase.this.issueStateTransition(OverScrollBounceEffectDecoratorBase.this.mIdleState);
                return true;
            }
            if (view.getParent() != null) {
                view.getParent().requestDisallowInterceptTouchEvent(true);
            }
            if ((dt = event.getEventTime() - event.getHistoricalEventTime(0)) > 0L) {
                OverScrollBounceEffectDecoratorBase.this.mVelocity = deltaOffset / (float)dt;
            }
            OverScrollBounceEffectDecoratorBase.this.translateView(view, newOffset);
            OverScrollBounceEffectDecoratorBase.this.mUpdateListener.onOverScrollUpdate(OverScrollBounceEffectDecoratorBase.this, this.mCurrDragState, newOffset);
            return true;
        }

        @Override
        public boolean handleUpOrCancelTouchEvent(MotionEvent event) {
            OverScrollBounceEffectDecoratorBase.this.issueStateTransition(OverScrollBounceEffectDecoratorBase.this.mBounceBackState);
            return false;
        }

        @Override
        public void handleEntryTransition(IDecoratorState fromState) {
            this.mCurrDragState = OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir ? 1 : 2;
            OverScrollBounceEffectDecoratorBase.this.mStateListener.onOverScrollStateChange(OverScrollBounceEffectDecoratorBase.this, fromState.getStateId(), this.getStateId());
        }
    }

    protected class IdleState
    implements IDecoratorState {
        final MotionAttributes mMoveAttr;

        public IdleState() {
            this.mMoveAttr = OverScrollBounceEffectDecoratorBase.this.createMotionAttributes();
        }

        @Override
        public int getStateId() {
            return 0;
        }

        @Override
        public boolean handleMoveTouchEvent(MotionEvent event) {
            View view = OverScrollBounceEffectDecoratorBase.this.mViewAdapter.getView();
            if (!this.mMoveAttr.init(view, event)) {
                return false;
            }
            if (OverScrollBounceEffectDecoratorBase.this.mViewAdapter.isInAbsoluteStart() && this.mMoveAttr.mDir || OverScrollBounceEffectDecoratorBase.this.mViewAdapter.isInAbsoluteEnd() && !this.mMoveAttr.mDir) {
                OverScrollBounceEffectDecoratorBase.this.mStartAttr.mPointerId = event.getPointerId(0);
                OverScrollBounceEffectDecoratorBase.this.mStartAttr.mAbsOffset = this.mMoveAttr.mAbsOffset;
                OverScrollBounceEffectDecoratorBase.this.mStartAttr.mDir = this.mMoveAttr.mDir;
                OverScrollBounceEffectDecoratorBase.this.issueStateTransition(OverScrollBounceEffectDecoratorBase.this.mOverScrollingState);
                return OverScrollBounceEffectDecoratorBase.this.mOverScrollingState.handleMoveTouchEvent(event);
            }
            return false;
        }

        @Override
        public boolean handleUpOrCancelTouchEvent(MotionEvent event) {
            return false;
        }

        @Override
        public void handleEntryTransition(IDecoratorState fromState) {
            OverScrollBounceEffectDecoratorBase.this.mStateListener.onOverScrollStateChange(OverScrollBounceEffectDecoratorBase.this, fromState.getStateId(), this.getStateId());
        }
    }

    protected static interface IDecoratorState {
        public boolean handleMoveTouchEvent(MotionEvent var1);

        public boolean handleUpOrCancelTouchEvent(MotionEvent var1);

        public void handleEntryTransition(IDecoratorState var1);

        public int getStateId();
    }

    protected static abstract class AnimationAttributes {
        public Property<View, Float> mProperty;
        public float mAbsOffset;
        public float mMaxOffset;

        protected AnimationAttributes() {
        }

        protected abstract void init(View var1);
    }

    protected static class OverScrollStartAttributes {
        protected int mPointerId;
        protected float mAbsOffset;
        protected boolean mDir;

        protected OverScrollStartAttributes() {
        }
    }

    protected static abstract class MotionAttributes {
        public float mAbsOffset;
        public float mDeltaOffset;
        public boolean mDir;

        protected MotionAttributes() {
        }

        protected abstract boolean init(View var1, MotionEvent var2);
    }
}

