/*
 * Decompiled with CFR 0.152.
 */
package com.elyeproj.loaderviewlibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.elyeproj.loaderviewlibrary.LoaderController;
import com.elyeproj.loaderviewlibrary.LoaderView;
import com.elyeproj.loaderviewlibrary.R;

public class LoaderTextView
extends AppCompatTextView
implements LoaderView {
    private LoaderController loaderController;
    private int defaultColorResource;
    private int darkerColorResource;

    public LoaderTextView(Context context) {
        super(context);
        this.init(null);
    }

    public LoaderTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LoaderTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.loaderController = new LoaderController(this);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.loader_view, 0, 0);
        this.loaderController.setWidthWeight(typedArray.getFloat(R.styleable.loader_view_width_weight, 1.0f));
        this.loaderController.setHeightWeight(typedArray.getFloat(R.styleable.loader_view_height_weight, 1.0f));
        this.loaderController.setUseGradient(typedArray.getBoolean(R.styleable.loader_view_use_gradient, false));
        this.loaderController.setCorners(typedArray.getInt(R.styleable.loader_view_corners, 0));
        this.defaultColorResource = typedArray.getColor(R.styleable.loader_view_custom_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_color));
        this.darkerColorResource = typedArray.getColor(R.styleable.loader_view_custom_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.darker_color));
        typedArray.recycle();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.loaderController.onSizeChanged();
    }

    public void resetLoader() {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            super.setText(null);
            this.loaderController.startLoading();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.loaderController.onDraw(canvas, this.getCompoundPaddingLeft(), this.getCompoundPaddingTop(), this.getCompoundPaddingRight(), this.getCompoundPaddingBottom());
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        if (this.loaderController != null) {
            this.loaderController.stopLoading();
        }
    }

    @Override
    public void setRectColor(Paint rectPaint) {
        Typeface typeface = this.getTypeface();
        if (typeface != null && typeface.getStyle() == 1) {
            rectPaint.setColor(this.darkerColorResource);
        } else {
            rectPaint.setColor(this.defaultColorResource);
        }
    }

    @Override
    public boolean valueSet() {
        return !TextUtils.isEmpty((CharSequence)this.getText());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.loaderController.removeAnimatorUpdateListener();
    }
}

