/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.reachingdef;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.visualize.CFGVisualizer;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.dataflow.reachingdef.ReachingDefinitionNode;
import org.checkerframework.errorprone.javacutil.BugInCF;

public class ReachingDefinitionStore
implements Store<ReachingDefinitionStore> {
    private final Set<ReachingDefinitionNode> reachingDefSet;

    public ReachingDefinitionStore() {
        this.reachingDefSet = new LinkedHashSet<ReachingDefinitionNode>();
    }

    public ReachingDefinitionStore(Set<ReachingDefinitionNode> reachingDefSet) {
        this.reachingDefSet = reachingDefSet;
    }

    public void killDef(Node defTarget) {
        Iterator<ReachingDefinitionNode> it = this.reachingDefSet.iterator();
        while (it.hasNext()) {
            ReachingDefinitionNode generatedDefNode = it.next();
            if (!generatedDefNode.def.getTarget().equals(defTarget)) continue;
            it.remove();
        }
    }

    public void putDef(ReachingDefinitionNode def) {
        this.reachingDefSet.add(def);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ReachingDefinitionStore)) {
            return false;
        }
        ReachingDefinitionStore other = (ReachingDefinitionStore)obj;
        return other.reachingDefSet.equals(this.reachingDefSet);
    }

    public int hashCode() {
        return this.reachingDefSet.hashCode();
    }

    @Override
    public ReachingDefinitionStore copy() {
        return new ReachingDefinitionStore(new LinkedHashSet<ReachingDefinitionNode>(this.reachingDefSet));
    }

    @Override
    public ReachingDefinitionStore leastUpperBound(ReachingDefinitionStore other) {
        LinkedHashSet<ReachingDefinitionNode> reachingDefSetLub = new LinkedHashSet<ReachingDefinitionNode>(this.reachingDefSet.size() + other.reachingDefSet.size());
        reachingDefSetLub.addAll(this.reachingDefSet);
        reachingDefSetLub.addAll(other.reachingDefSet);
        return new ReachingDefinitionStore(reachingDefSetLub);
    }

    @Override
    public ReachingDefinitionStore widenedUpperBound(ReachingDefinitionStore previous) {
        throw new BugInCF("ReachingDefinitionStore.widenedUpperBound was called!");
    }

    @Override
    public boolean canAlias(JavaExpression a, JavaExpression b) {
        return true;
    }

    @Override
    public String visualize(CFGVisualizer<?, ReachingDefinitionStore, ?> viz) {
        String key = "reaching definitions";
        if (this.reachingDefSet.isEmpty()) {
            return viz.visualizeStoreKeyVal(key, "none");
        }
        StringJoiner sjStoreVal = new StringJoiner(", ", "{ ", " }");
        for (ReachingDefinitionNode reachDefNode : this.reachingDefSet) {
            sjStoreVal.add(reachDefNode.toString());
        }
        return viz.visualizeStoreKeyVal(key, sjStoreVal.toString());
    }

    public String toString() {
        return "ReachingDefinitionStore: " + this.reachingDefSet.toString();
    }
}

