/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.boot;

import io.github.ecsoya.fabric.boot.SpringFabricProperties;
import io.github.ecsoya.fabric.config.FabricContext;
import io.github.ecsoya.fabric.config.FabricProperties;
import io.github.ecsoya.fabric.service.IFabricInfoService;
import io.github.ecsoya.fabric.service.IFabricObjectService;
import io.github.ecsoya.fabric.service.impl.FabricInfoServiceImpl;
import io.github.ecsoya.fabric.service.impl.FabricObjectServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={SpringFabricProperties.class})
public class SpringFabricGatewayAutoConfigure {
    private Logger logger = LoggerFactory.getLogger(SpringFabricGatewayAutoConfigure.class);
    @Autowired
    private SpringFabricProperties properties;

    @Bean
    @Primary
    public FabricContext fabricContext() {
        this.logger.info("Init SpringFabricGateway: " + (Object)((Object)this.properties));
        return new FabricContext((FabricProperties)this.properties);
    }

    @Bean
    public IFabricObjectService fabricService(FabricContext fabricContext) {
        return new FabricObjectServiceImpl(fabricContext);
    }

    @Bean
    public IFabricInfoService fabricInfoService(FabricContext fabricContext) {
        return new FabricInfoServiceImpl(fabricContext);
    }
}

