/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.explorer.controller;

import io.github.ecsoya.fabric.FabricPagination;
import io.github.ecsoya.fabric.FabricPaginationQuery;
import io.github.ecsoya.fabric.FabricQueryResponse;
import io.github.ecsoya.fabric.bean.FabricBlock;
import io.github.ecsoya.fabric.bean.FabricHistory;
import io.github.ecsoya.fabric.bean.FabricLedger;
import io.github.ecsoya.fabric.bean.FabricTransaction;
import io.github.ecsoya.fabric.bean.FabricTransactionRWSet;
import io.github.ecsoya.fabric.explorer.FabricExplorerProperties;
import io.github.ecsoya.fabric.service.IFabricInfoService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

public class FabricExplorerController {
    @Autowired
    private IFabricInfoService fabricService;
    @Autowired
    private FabricExplorerProperties properties;

    private String baseUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int port = request.getServerPort();
        String path = request.getContextPath();
        return scheme + "://" + serverName + ":" + port + path;
    }

    @GetMapping(value={"/"})
    public ModelAndView home(HttpServletRequest request) {
        ModelAndView model = new ModelAndView("explorer/index");
        model.addAllObjects(this.properties.toMap());
        model.addObject("baseURL", (Object)this.baseUrl(request));
        return model;
    }

    @GetMapping(value={"/block"})
    public ModelAndView block(HttpServletRequest request, long height) {
        ModelAndView model = new ModelAndView("explorer/block");
        model.addAllObjects(this.properties.toMap());
        model.addObject("height", (Object)height);
        model.addObject("baseURL", (Object)this.baseUrl(request));
        return model;
    }

    @GetMapping(value={"/tx"})
    public ModelAndView tx(HttpServletRequest request, String txid) {
        ModelAndView model = new ModelAndView("explorer/tx");
        model.addAllObjects(this.properties.toMap());
        model.addObject("txid", (Object)txid);
        model.addObject("baseURL", (Object)this.baseUrl(request));
        return model;
    }

    @PostMapping(value={"/history"})
    public ModelAndView history(HttpServletRequest request, String key, String type) {
        ModelAndView model = new ModelAndView("explorer/history");
        model.addAllObjects(this.properties.toMap());
        model.addObject("key", (Object)key);
        model.addObject("type", (Object)type);
        model.addObject("baseURL", (Object)this.baseUrl(request));
        return model;
    }

    @PostMapping(value={"/query/ledger"})
    @ResponseBody
    public FabricQueryResponse<FabricLedger> queryFabricLedger() {
        return this.fabricService.queryFabricLedger();
    }

    @PostMapping(value={"/query/blockpage"})
    @ResponseBody
    public FabricPagination<FabricBlock> queryBlocks(@RequestBody FabricPaginationQuery<FabricBlock> query) {
        return this.fabricService.queryBlocks(query);
    }

    @GetMapping(value={"/query/block/{number}"})
    @ResponseBody
    public FabricQueryResponse<FabricBlock> queryBlockInfo(@PathVariable(value="number") long blockNumber) {
        return this.fabricService.queryBlockByNumber(blockNumber);
    }

    @GetMapping(value={"/query/tx/{id}"})
    @ResponseBody
    public FabricQueryResponse<FabricTransaction> queryTransactionInfo(@PathVariable(value="id") String txid) {
        return this.fabricService.queryTransaction(txid);
    }

    @GetMapping(value={"/query/transactions/{number}"})
    @ResponseBody
    public FabricQueryResponse<List<FabricTransaction>> queryTransactions(@PathVariable(value="number") long blockNumber) {
        return this.fabricService.queryTransactions(blockNumber);
    }

    @GetMapping(value={"/query/txrw/{id}"})
    @ResponseBody
    public FabricQueryResponse<FabricTransactionRWSet> queryTransactionRWSet(@PathVariable(value="id") String txid) {
        return this.fabricService.queryTransactionRWSet(txid);
    }

    @GetMapping(value={"/query/history"})
    @ResponseBody
    public FabricQueryResponse<List<FabricHistory>> queryHistories(String type, String key) {
        return this.fabricService.queryHistory(type, key);
    }
}

