/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.explorer;

import io.github.ecsoya.fabric.explorer.FabricExplorerProperties;
import io.github.ecsoya.fabric.explorer.controller.FabricExplorerController;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class FabricExplorerHandlerMapping
extends RequestMappingHandlerMapping {
    private Logger logger = LoggerFactory.getLogger(FabricExplorerHandlerMapping.class);
    @Autowired
    private FabricExplorerProperties properties;

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        String path = this.properties.getPath();
        PatternsRequestCondition oldPatternCondition = mapping.getPatternsCondition();
        Set patterns = oldPatternCondition.getPatterns();
        if (patterns != null && !patterns.isEmpty() && !"".equals(path)) {
            String[] newPatterns = patterns.stream().map(p -> {
                String value;
                if (!p.startsWith("/")) {
                    p = "/" + p;
                }
                if ((value = "/" + path + p).endsWith("/")) {
                    value = value.substring(0, value.length() - 1);
                }
                return value;
            }).collect(Collectors.toSet()).toArray(new String[0]);
            mapping = new RequestMappingInfo(new PatternsRequestCondition(newPatterns), mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
        }
        this.logger.info("Fabric Explorer Registered Mapping: " + mapping);
        super.registerHandlerMethod(handler, method, mapping);
    }

    protected boolean isHandler(Class<?> beanType) {
        return FabricExplorerController.class == beanType;
    }
}

