/*
 * Decompiled with CFR 0.152.
 */
package io.github.ecsoya.fabric.explorer;

import io.github.ecsoya.fabric.boot.SpringFabricGatewayAutoConfigure;
import io.github.ecsoya.fabric.explorer.FabricExplorerHandlerMapping;
import io.github.ecsoya.fabric.explorer.FabricExplorerProperties;
import io.github.ecsoya.fabric.explorer.controller.FabricExplorerController;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractResourceBasedMessageSource;

@Configuration
@ImportAutoConfiguration(classes={SpringFabricGatewayAutoConfigure.class, MessageSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={FabricExplorerProperties.class})
public class FabricExplorerAutoConfiguration {
    private Logger logger = LoggerFactory.getLogger(FabricExplorerAutoConfiguration.class);
    @Autowired
    private FabricExplorerProperties properties;
    @Autowired(required=false)
    private MessageSource messageSource;

    @PostConstruct
    private void initialize() {
        this.logger.info("Init FabricExplorerAutoConfiguration: " + this.properties);
        if (this.messageSource instanceof AbstractResourceBasedMessageSource) {
            ((AbstractResourceBasedMessageSource)this.messageSource).addBasenames(new String[]{"static/i18n/explorer"});
        }
    }

    @Bean
    public FabricExplorerHandlerMapping fabricExplorerHandlerMapping() {
        FabricExplorerHandlerMapping mapping = new FabricExplorerHandlerMapping();
        mapping.setOrder(0x7FFFFFFC);
        return mapping;
    }

    @Bean
    public FabricExplorerController fabricExplorerController() {
        return new FabricExplorerController();
    }
}

