/*
 * Decompiled with CFR 0.152.
 */
package me.dkim19375.dkimbukkitcore.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.dkim19375.dkimcore.annotation.API;
import me.dkim19375.dkimcore.extension.IOFunctionsKt;
import me.dkim19375.dkimcore.file.DataFile;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017H\u0007J\u001a\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u0007J\b\u0010\u001e\u001a\u00020\u0007H\u0007J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0005H\u0007J\b\u0010!\u001a\u00020\u0007H\u0007J\b\u0010\"\u001a\u00020\u0007H\u0007J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J\b\u0010%\u001a\u00020\u0015H\u0017J\b\u0010&\u001a\u00020\u0015H\u0007J\b\u0010'\u001a\u00020\u0015H\u0017J\b\u0010(\u001a\u00020\u0015H\u0007J\b\u0010)\u001a\u00020\u0015H\u0002J\b\u0010*\u001a\u00020\u0015H\u0007R&\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006+"}, d2={"Lme/dkim19375/dkimbukkitcore/config/ConfigFile;", "Lme/dkim19375/dkimcore/file/DataFile;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "fileName", "", "useDataFolder", "", "(Lorg/bukkit/plugin/java/JavaPlugin;Ljava/lang/String;Z)V", "<set-?>", "Lorg/bukkit/configuration/file/FileConfiguration;", "config", "getConfig$annotations", "()V", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "pluginDataFolder", "Ljava/io/File;", "getPluginDataFolder", "()Ljava/io/File;", "addDefaults", "", "defaults", "", "", "addIfDoesntExist", "key", "value", "contains", "ignoreDefault", "createConfig", "createSubDirectory", "name", "deleteDir", "deleteFile", "getResource", "Ljava/io/InputStream;", "reload", "reset", "save", "saveDefaultConfig", "saveResource", "wipeDirectory", "DkimBukkitCore"})
public final class ConfigFile
extends DataFile {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private FileConfiguration config;

    /*
     * WARNING - void declaration
     */
    public ConfigFile(@NotNull JavaPlugin plugin, @NotNull String fileName, boolean useDataFolder) {
        void it;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = fileName;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string;
        ConfigFile configFile = this;
        boolean bl3 = false;
        String name = StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        String string3 = (useDataFolder ? new File(plugin.getDataFolder(), name) : new File(name)).getPath();
        String string4 = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fileName.let {\n    val name = it.replace('\\\\', '/')\n    (if (useDataFolder) File(plugin.dataFolder, name) else File(name)).path\n}");
        super(string4);
        this.plugin = plugin;
        string4 = YamlConfiguration.loadConfiguration((File)this.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"loadConfiguration(file)");
        this.config = (FileConfiguration)string4;
    }

    public /* synthetic */ ConfigFile(JavaPlugin javaPlugin, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(javaPlugin, string, bl);
    }

    @NotNull
    public final FileConfiguration getConfig() {
        return this.config;
    }

    @API
    public static /* synthetic */ void getConfig$annotations() {
    }

    private final File getPluginDataFolder() {
        File file = this.getFile().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file.parentFile");
        return file;
    }

    @API
    public final boolean createConfig() {
        boolean success = false;
        if (!this.getFile().exists()) {
            if (!this.getPluginDataFolder().exists() && this.getPluginDataFolder().mkdir()) {
                success = true;
            }
            try {
                if (this.getFile().createNewFile()) {
                    success = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                success = false;
            }
        }
        return success;
    }

    @API
    public final void addIfDoesntExist(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.config.getString(key) == null) {
            this.config.set(key, (Object)value);
        }
    }

    @API
    public final void addDefaults(@NotNull Map<String, ? extends Object> defaults) {
        Intrinsics.checkNotNullParameter(defaults, (String)"defaults");
        this.config.addDefaults(defaults);
    }

    @API
    public void save() {
        super.save();
        this.config.save(this.getFile());
    }

    @API
    public void reload() {
        super.reload();
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(file)");
        this.config = (FileConfiguration)yamlConfiguration;
    }

    @API
    public final boolean deleteFile() {
        return this.getFile().delete();
    }

    @API
    public final boolean deleteDir() {
        return FilesKt.deleteRecursively((File)this.getPluginDataFolder());
    }

    @API
    public final void reset() {
        this.deleteFile();
        IOFunctionsKt.createFileAndDirs((File)this.getFile());
    }

    @API
    public final void wipeDirectory() {
        this.deleteDir();
        Path path = this.getPluginDataFolder().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginDataFolder.toPath()");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
    }

    @API
    public final void createSubDirectory(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path path = this.getPluginDataFolder().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginDataFolder.toPath()");
        Object object = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        Path subDir = new File(this.getPluginDataFolder(), name).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)subDir, (String)"subDir");
        object = subDir;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
    }

    public final boolean contains(@NotNull String value, boolean ignoreDefault) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.config.contains(value, ignoreDefault);
    }

    public static /* synthetic */ boolean contains$default(ConfigFile configFile, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return configFile.contains(string, bl);
    }

    private final InputStream getResource() {
        InputStream inputStream = this.plugin.getClass().getClassLoader().getResourceAsStream(this.getFileName());
        return inputStream == null ? this.plugin.getClass().getResourceAsStream(this.getFileName()) : inputStream;
    }

    @API
    public final void saveDefaultConfig() {
        if (!this.getFile().exists()) {
            this.saveResource();
        }
    }

    private final void saveResource() {
        InputStream resource = this.getResource();
        if (resource == null) {
            IOFunctionsKt.createFileAndDirs((Path)this.getPath());
            return;
        }
        Path path = this.getPath().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path.parent");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        Files.copy(resource, this.getPath(), new CopyOption[0]);
    }
}

