/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.easyrefresh;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Scroller;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.didichuxing.doraemonkit.widget.easyrefresh.ILoadMoreView;
import com.didichuxing.doraemonkit.widget.easyrefresh.IRefreshHeader;
import com.didichuxing.doraemonkit.widget.easyrefresh.LoadModel;
import com.didichuxing.doraemonkit.widget.easyrefresh.State;
import com.didichuxing.doraemonkit.widget.easyrefresh.exception.ERVHRuntimeException;
import com.didichuxing.doraemonkit.widget.easyrefresh.view.SimpleLoadMoreView;
import com.didichuxing.doraemonkit.widget.easyrefresh.view.SimpleRefreshHeaderView;

public class EasyRefreshLayout
extends ViewGroup {
    private static final String TAG = "EsayRefreshLayout";
    private static int SCROLL_TO_REFRESH_DURATION = 250;
    private static int SCROLL_TO_TOP_DURATION = 800;
    private static final int INVALID_POINTER = -1;
    private static final float DRAG_RATE = 1.0f;
    private static final int START_POSITION = 0;
    private static long SHOW_COMPLETED_TIME = 500L;
    private static long SCROLL_TO_LOADING_DURATION = 500L;
    private static long SHOW_SCROLL_DOWN_DURATION = 300L;
    private double pull_resistance = 2.0;
    private State state = State.RESET;
    private boolean isEnablePullToRefresh = true;
    private boolean isRefreshing;
    private int touchSlop;
    private View refreshHeaderView;
    private int currentOffsetTop;
    private View contentView;
    private boolean hasMeasureHeaderView = false;
    private int headerViewHight;
    private int totalDragDistance;
    private int activePointerId;
    private boolean isTouch;
    private boolean hasSendCancelEvent;
    private boolean isBeginDragged;
    private int lastOffsetTop;
    private float lastMotionX;
    private float lastMotionY;
    private float initDownY;
    private float initDownX;
    private MotionEvent lastEvent;
    private AutoScroll autoScroll;
    private boolean isAutoRefresh;
    private EasyEvent easyEvent;
    private RecyclerView mRecyclerView;
    boolean isCanLoad = false;
    private LayoutInflater mInflater;
    private boolean isLoading = false;
    private View mLoadMoreView;
    private boolean isLoadingFail = false;
    private float offsetY;
    private float yDiff;
    private float mDistance;
    private LoadModel loadMoreModel = LoadModel.COMMON_MODEL;
    private int advanceCount = 0;
    private Runnable delayToScrollTopRunnable = new Runnable(){

        @Override
        public void run() {
            EasyRefreshLayout.this.autoScroll.scrollTo(0, SCROLL_TO_TOP_DURATION);
        }
    };
    private Runnable autoRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            EasyRefreshLayout.this.isAutoRefresh = true;
            EasyRefreshLayout.this.changeState(State.PULL);
            EasyRefreshLayout.this.autoScroll.scrollTo(EasyRefreshLayout.this.totalDragDistance, SCROLL_TO_REFRESH_DURATION);
        }
    };
    private boolean hasMeasureLoadMoreView;
    private int loadMoreViewHeight;
    private boolean isRecycerView;
    private boolean isNotMoreLoading;

    public EasyRefreshLayout(Context context) {
        this(context, null);
    }

    public EasyRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initParameter(context, attrs);
    }

    private void initParameter(Context context, AttributeSet attrs) {
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        View refreshHeadView = this.getDefaultRefreshView();
        this.setRefreshHeadView(refreshHeadView);
        View loadMoreView = this.getDefaultLoadMoreView();
        this.setLoadMoreView(loadMoreView);
        this.autoScroll = new AutoScroll();
    }

    public void setRefreshHeadView(View headerView) {
        ViewGroup.LayoutParams layoutParams;
        if (headerView != null && headerView != this.refreshHeaderView) {
            this.removeView(this.refreshHeaderView);
        }
        if ((layoutParams = headerView.getLayoutParams()) == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, -2);
            headerView.setLayoutParams(layoutParams);
        }
        this.refreshHeaderView = headerView;
        this.addView(this.refreshHeaderView);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.contentView == null) {
            this.initContentView();
        }
        if (this.contentView == null) {
            return;
        }
        int contentViewWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int contentViewHight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        this.contentView.measure(View.MeasureSpec.makeMeasureSpec((int)contentViewWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)contentViewHight, (int)0x40000000));
        this.measureChild(this.refreshHeaderView, widthMeasureSpec, heightMeasureSpec);
        if (!this.hasMeasureHeaderView) {
            this.hasMeasureHeaderView = true;
            this.totalDragDistance = this.headerViewHight = this.refreshHeaderView.getMeasuredHeight();
        }
        this.measureChild(this.mLoadMoreView, widthMeasureSpec, heightMeasureSpec);
        if (!this.hasMeasureLoadMoreView) {
            this.hasMeasureLoadMoreView = true;
            this.loadMoreViewHeight = this.mLoadMoreView.getMeasuredHeight();
        }
    }

    private void initContentView() {
        if (this.contentView == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child.equals(this.refreshHeaderView) || child.equals(this.mLoadMoreView)) continue;
                this.contentView = child;
                if (this.contentView instanceof RecyclerView) {
                    this.isRecycerView = true;
                    break;
                }
                this.isRecycerView = false;
                break;
            }
        }
        if (this.isRecycerView) {
            this.initERVH();
        }
    }

    protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        if (this.getChildCount() == 0) {
            throw new RuntimeException("child view can not be empty");
        }
        if (this.contentView == null) {
            this.initContentView();
        }
        if (this.contentView == null) {
            throw new RuntimeException("main content of view can not be empty ");
        }
        View child = this.contentView;
        int childLeft = this.getPaddingLeft();
        int childTop = this.getPaddingTop() + this.currentOffsetTop;
        int childWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int childHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        int refreshViewWidth = this.refreshHeaderView.getMeasuredWidth();
        this.refreshHeaderView.layout(width / 2 - refreshViewWidth / 2, -this.headerViewHight + this.currentOffsetTop, width / 2 + refreshViewWidth / 2, this.currentOffsetTop);
        int loadMoreViewWidth = this.mLoadMoreView.getMeasuredWidth();
        int loadL = width / 2 - loadMoreViewWidth / 2;
        int loadT = childHeight;
        int loadR = width / 2 + loadMoreViewWidth / 2;
        int loadB = childHeight + this.loadMoreViewHeight;
        this.mLoadMoreView.layout(loadL, loadT, loadR, loadB);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isLoading || this.contentView == null) {
            return super.dispatchTouchEvent(ev);
        }
        int actionMasked = ev.getActionMasked();
        switch (actionMasked) {
            case 0: {
                this.mDistance = 0.0f;
                this.activePointerId = ev.getPointerId(0);
                this.isTouch = true;
                this.hasSendCancelEvent = false;
                this.isBeginDragged = false;
                this.lastOffsetTop = this.currentOffsetTop;
                this.currentOffsetTop = this.contentView.getTop();
                this.initDownX = this.lastMotionX = ev.getX(0);
                this.initDownY = this.lastMotionY = ev.getY(0);
                this.autoScroll.stop();
                this.removeCallbacks(this.delayToScrollTopRunnable);
                this.removeCallbacks(this.autoRefreshRunnable);
                super.dispatchTouchEvent(ev);
                return true;
            }
            case 2: {
                boolean canMoveHeadUp;
                if (this.activePointerId == -1) {
                    return super.dispatchTouchEvent(ev);
                }
                this.autoScroll.stop();
                this.lastEvent = ev;
                float x = ev.getX(MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.activePointerId));
                float y = ev.getY(MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.activePointerId));
                float xDiff = x - this.lastMotionX;
                this.yDiff = y - this.lastMotionY;
                this.mDistance += this.yDiff;
                this.offsetY = this.yDiff * 1.0f;
                this.lastMotionX = x;
                this.lastMotionY = y;
                if (Math.abs(xDiff) > (float)this.touchSlop) break;
                if (!this.isBeginDragged && Math.abs(y - this.initDownY) > (float)this.touchSlop) {
                    this.isBeginDragged = true;
                }
                if (!this.isBeginDragged) break;
                boolean isMoveHeadDown = this.offsetY > 0.0f;
                boolean canMoveHeadDown = !this.canChildScrollUp();
                boolean isMoveHeadUp = !isMoveHeadDown;
                boolean bl = canMoveHeadUp = this.currentOffsetTop > 0;
                if ((!isMoveHeadDown || !canMoveHeadDown) && (!isMoveHeadUp || !canMoveHeadUp)) break;
                this.moveSpinner(this.offsetY);
                return true;
            }
            case 1: 
            case 3: {
                if (this.currentOffsetTop > 0) {
                    this.finishSpinner();
                }
                this.isTouch = false;
                this.activePointerId = -1;
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                if (pointerIndex < 0) {
                    return super.dispatchTouchEvent(ev);
                }
                this.lastMotionX = ev.getX(pointerIndex);
                this.lastMotionY = ev.getY(pointerIndex);
                this.activePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.lastMotionY = ev.getY(ev.findPointerIndex(this.activePointerId));
                this.lastMotionX = ev.getX(ev.findPointerIndex(this.activePointerId));
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.activePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.lastMotionY = ev.getY(newPointerIndex);
            this.lastMotionX = ev.getX(newPointerIndex);
            this.activePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private void moveSpinner(float offsetY) {
        if (!this.isEnablePullToRefresh) {
            return;
        }
        int offset = Math.round(offsetY);
        if (offset == 0) {
            return;
        }
        if (!this.hasSendCancelEvent && this.isTouch && this.currentOffsetTop > 0) {
            this.sendCancelEvent();
            this.hasSendCancelEvent = true;
        }
        int nextOffsetTop = Math.max(0, this.currentOffsetTop + offset);
        offset = nextOffsetTop - this.currentOffsetTop;
        float extraOS = nextOffsetTop - this.totalDragDistance;
        float slingshotDist = this.totalDragDistance;
        float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, slingshotDist * 2.0f) / slingshotDist);
        float tensionPercent = (float)((double)tensionSlingshotPercent - Math.pow((double)tensionSlingshotPercent / this.pull_resistance, 2.0));
        if (offset > 0) {
            offset = (int)((float)offset * (1.0f - tensionPercent));
            nextOffsetTop = Math.max(0, this.currentOffsetTop + offset);
        }
        if (this.state == State.RESET && this.currentOffsetTop == 0 && nextOffsetTop > 0) {
            if (this.isNotMoreLoading || this.isLoadingFail) {
                this.closeLoadView();
            }
            this.changeState(State.PULL);
        }
        if (this.currentOffsetTop > 0 && nextOffsetTop <= 0 && (this.state == State.PULL || this.state == State.COMPLETE)) {
            this.changeState(State.RESET);
        }
        if (this.state == State.PULL && !this.isTouch && this.currentOffsetTop > this.totalDragDistance && nextOffsetTop <= this.totalDragDistance) {
            this.autoScroll.stop();
            this.changeState(State.REFRESHING);
            if (this.easyEvent != null) {
                this.isRefreshing = true;
                this.easyEvent.onRefreshing();
            }
            int adjustOffset = this.totalDragDistance - nextOffsetTop;
            offset += adjustOffset;
        }
        this.setTargetOffsetTopAndBottom(offset);
        if (this.refreshHeaderView instanceof IRefreshHeader) {
            ((IRefreshHeader)this.refreshHeaderView).onPositionChange(this.currentOffsetTop, this.lastOffsetTop, this.totalDragDistance, this.isTouch, this.state);
        }
    }

    private void finishSpinner() {
        if (this.state == State.REFRESHING) {
            if (this.currentOffsetTop > this.totalDragDistance) {
                this.autoScroll.scrollTo(this.totalDragDistance, SCROLL_TO_REFRESH_DURATION);
            }
        } else {
            this.autoScroll.scrollTo(0, SCROLL_TO_TOP_DURATION);
        }
    }

    private boolean canChildScrollUp() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.contentView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.contentView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.contentView, (int)-1) || this.contentView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.contentView, (int)-1);
    }

    private void setTargetOffsetTopAndBottom(int offset) {
        if (offset == 0) {
            return;
        }
        this.contentView.offsetTopAndBottom(offset);
        this.refreshHeaderView.offsetTopAndBottom(offset);
        this.lastOffsetTop = this.currentOffsetTop;
        this.currentOffsetTop = this.contentView.getTop();
        this.invalidate();
    }

    private void sendCancelEvent() {
        if (this.lastEvent == null) {
            return;
        }
        MotionEvent ev = MotionEvent.obtain((MotionEvent)this.lastEvent);
        ev.setAction(3);
        super.dispatchTouchEvent(ev);
    }

    private void changeState(State state) {
        IRefreshHeader refreshHeader;
        this.state = state;
        IRefreshHeader iRefreshHeader = refreshHeader = this.refreshHeaderView instanceof IRefreshHeader ? (IRefreshHeader)this.refreshHeaderView : null;
        if (refreshHeader != null) {
            switch (state) {
                case RESET: {
                    refreshHeader.reset();
                    break;
                }
                case PULL: {
                    refreshHeader.pull();
                    break;
                }
                case REFRESHING: {
                    refreshHeader.refreshing();
                    break;
                }
                case COMPLETE: {
                    refreshHeader.complete();
                }
            }
        }
    }

    public void refreshComplete() {
        this.isRefreshing = false;
        this.changeState(State.COMPLETE);
        if (this.currentOffsetTop == 0) {
            this.changeState(State.RESET);
        } else if (!this.isTouch) {
            this.postDelayed(this.delayToScrollTopRunnable, SHOW_COMPLETED_TIME);
        }
    }

    public void autoRefresh() {
        this.autoRefresh(500L);
    }

    public void autoRefresh(long duration) {
        if (this.state != State.RESET) {
            return;
        }
        this.postDelayed(this.autoRefreshRunnable, duration);
    }

    public View getDefaultRefreshView() {
        return new SimpleRefreshHeaderView(this.getContext());
    }

    private void onScrollFinish(boolean isForceFinish) {
        if (this.isAutoRefresh && !isForceFinish) {
            this.isAutoRefresh = false;
            this.changeState(State.REFRESHING);
            if (this.easyEvent != null) {
                this.easyEvent.onRefreshing();
            }
            this.finishSpinner();
        }
    }

    public void addEasyEvent(EasyEvent event) {
        if (event == null) {
            throw new ERVHRuntimeException("adapter can not be null");
        }
        this.easyEvent = event;
    }

    public boolean isEnablePullToRefresh() {
        return this.isEnablePullToRefresh;
    }

    public void setEnablePullToRefresh(boolean enable) {
        this.isEnablePullToRefresh = enable;
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void setRefreshing(boolean refreshing) {
        if (refreshing) {
            this.changeState(State.REFRESHING);
            if (this.isNotMoreLoading || this.isLoadingFail) {
                this.closeLoadView();
            }
        }
        this.changeState(State.RESET);
    }

    private void initERVH() {
        if (this.mLoadMoreView == null) {
            this.getDefaultLoadMoreView();
            this.setLoadMoreView(this.mLoadMoreView);
        }
        if (!this.isRecycerView) {
            return;
        }
        this.mRecyclerView = (RecyclerView)this.contentView;
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (!(EasyRefreshLayout.this.loadMoreModel != LoadModel.ADVANCE_MODEL || EasyRefreshLayout.this.isLoading || EasyRefreshLayout.this.isRefreshing || EasyRefreshLayout.this.isLoadingFail || EasyRefreshLayout.this.isNotMoreLoading)) {
                    int lastVisibleItem = EasyRefreshLayout.this.getLastVisiBleItem();
                    int totalItemCount = EasyRefreshLayout.this.mRecyclerView.getLayoutManager().getItemCount();
                    int totalChildCount = EasyRefreshLayout.this.mRecyclerView.getLayoutManager().getChildCount();
                    if (totalChildCount > 0 && lastVisibleItem >= totalItemCount - 1 - EasyRefreshLayout.this.advanceCount && totalItemCount >= totalChildCount) {
                        EasyRefreshLayout.this.isCanLoad = true;
                    }
                    if (EasyRefreshLayout.this.isCanLoad) {
                        EasyRefreshLayout.this.isCanLoad = false;
                        EasyRefreshLayout.this.isLoading = true;
                        if (EasyRefreshLayout.this.easyEvent != null) {
                            EasyRefreshLayout.this.easyEvent.onLoadMore();
                        }
                    }
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (EasyRefreshLayout.this.loadMoreModel == LoadModel.ADVANCE_MODEL) {
                    return;
                }
                if (Math.abs(EasyRefreshLayout.this.mDistance) > (float)EasyRefreshLayout.this.touchSlop && EasyRefreshLayout.this.mDistance < 0.0f && !EasyRefreshLayout.this.isLoading && EasyRefreshLayout.this.loadMoreModel == LoadModel.COMMON_MODEL && !EasyRefreshLayout.this.isRefreshing && !EasyRefreshLayout.this.isLoadingFail && !EasyRefreshLayout.this.isNotMoreLoading) {
                    int lastVisibleItem = EasyRefreshLayout.this.getLastVisiBleItem();
                    int totalItemCount = EasyRefreshLayout.this.mRecyclerView.getLayoutManager().getItemCount();
                    int totalChildCount = EasyRefreshLayout.this.mRecyclerView.getLayoutManager().getChildCount();
                    if (totalChildCount > 0 && lastVisibleItem >= totalItemCount - 1 && totalItemCount >= totalChildCount) {
                        EasyRefreshLayout.this.isCanLoad = true;
                    }
                    if (EasyRefreshLayout.this.isCanLoad) {
                        EasyRefreshLayout.this.isCanLoad = false;
                        EasyRefreshLayout.this.isLoading = true;
                        ((ILoadMoreView)EasyRefreshLayout.this.mLoadMoreView).reset();
                        EasyRefreshLayout.this.mLoadMoreView.measure(0, 0);
                        ((ILoadMoreView)EasyRefreshLayout.this.mLoadMoreView).loading();
                        EasyRefreshLayout.this.showLoadView();
                    }
                }
            }
        });
    }

    private void showLoadView() {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, -this.mLoadMoreView.getMeasuredHeight()});
        animator.setTarget((Object)this.mLoadMoreView);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            private int lastDs;

            public void onAnimationUpdate(ValueAnimator animation) {
                int ds;
                this.lastDs = ds = ((Integer)animation.getAnimatedValue()).intValue();
                EasyRefreshLayout.this.mLoadMoreView.bringToFront();
                EasyRefreshLayout.this.mLoadMoreView.setTranslationY((float)ds);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (EasyRefreshLayout.this.easyEvent != null) {
                    EasyRefreshLayout.this.easyEvent.onLoadMore();
                }
            }
        });
        animator.setDuration(SCROLL_TO_LOADING_DURATION);
        animator.start();
    }

    private void hideLoadView() {
        if (this.mLoadMoreView != null && this.isRecycerView) {
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, this.mLoadMoreView.getMeasuredHeight()});
            animator.setTarget((Object)this.mLoadMoreView);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                private int lastDs;

                public void onAnimationUpdate(ValueAnimator animation) {
                    int ds;
                    this.lastDs = ds = ((Integer)animation.getAnimatedValue()).intValue();
                    EasyRefreshLayout.this.mLoadMoreView.bringToFront();
                    EasyRefreshLayout.this.mLoadMoreView.setTranslationY((float)ds);
                }
            });
            animator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    EasyRefreshLayout.this.isLoading = false;
                }

                public void onAnimationCancel(Animator animator) {
                    EasyRefreshLayout.this.isLoading = false;
                }

                public void onAnimationRepeat(Animator animator) {
                    EasyRefreshLayout.this.isLoading = false;
                }
            });
            animator.setDuration(SHOW_SCROLL_DOWN_DURATION);
            animator.start();
        }
    }

    public void closeLoadView() {
        if (this.loadMoreModel == LoadModel.ADVANCE_MODEL) {
            throw new RuntimeException("enableAdance Model cant not called closeLoadView method");
        }
        if (this.mLoadMoreView != null && this.isRecycerView) {
            this.mLoadMoreView.bringToFront();
            this.mLoadMoreView.setTranslationY((float)this.mLoadMoreView.getMeasuredHeight());
            this.resetLoadMoreState();
        }
    }

    public View getLoadMoreView() {
        return this.getDefaultLoadMoreView();
    }

    public void setLoadMoreView(View loadMoreView) {
        ViewGroup.LayoutParams layoutParams;
        if (loadMoreView == null) {
            throw new ERVHRuntimeException("loadMoreView can not be null");
        }
        if (loadMoreView != null && loadMoreView != this.mLoadMoreView) {
            this.removeView(this.mLoadMoreView);
        }
        if ((layoutParams = loadMoreView.getLayoutParams()) == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, -2);
            loadMoreView.setLayoutParams(layoutParams);
        }
        this.mLoadMoreView = loadMoreView;
        this.addView(this.mLoadMoreView);
        this.resetLoadMoreState();
        ((ILoadMoreView)this.mLoadMoreView).reset();
        ((ILoadMoreView)this.mLoadMoreView).getCanClickFailView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EasyRefreshLayout.this.isLoadingFail && EasyRefreshLayout.this.easyEvent != null) {
                    EasyRefreshLayout.this.isLoading = true;
                    ((ILoadMoreView)EasyRefreshLayout.this.mLoadMoreView).loading();
                    EasyRefreshLayout.this.easyEvent.onLoadMore();
                }
            }
        });
    }

    public void loadMoreComplete() {
        if (this.loadMoreModel == LoadModel.ADVANCE_MODEL) {
            this.isLoading = false;
        } else if (this.loadMoreModel == LoadModel.COMMON_MODEL) {
            this.loadMoreComplete(null);
        }
    }

    @Deprecated
    public void loadMoreComplete(Event event) {
        if (this.loadMoreModel == LoadModel.ADVANCE_MODEL) {
            throw new RuntimeException("enableAdance Model cant not called closeLoadView method");
        }
        this.loadMoreComplete(event, 500L);
    }

    @Deprecated
    public void loadMoreComplete(final Event event, long delayedTime) {
        if (this.loadMoreModel == LoadModel.ADVANCE_MODEL) {
            throw new RuntimeException("enableAdance Model cant not called closeLoadView method");
        }
        ((ILoadMoreView)this.mLoadMoreView).loadComplete();
        if (event == null) {
            this.hideLoadView();
            this.resetLoadMoreState();
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                event.complete();
                EasyRefreshLayout.this.hideLoadView();
                EasyRefreshLayout.this.resetLoadMoreState();
            }
        }, delayedTime);
    }

    private void resetLoadMoreState() {
        this.isCanLoad = false;
        this.isLoading = false;
        this.isLoadingFail = false;
        this.isNotMoreLoading = false;
    }

    public void loadMoreFail() {
        if (this.loadMoreModel == LoadModel.ADVANCE_MODEL) {
            throw new RuntimeException("enableAdance Model cant not called closeLoadView method");
        }
        ((ILoadMoreView)this.mLoadMoreView).loadFail();
        this.resetLoadMoreState();
        this.isLoadingFail = true;
    }

    public void loadNothing() {
        if (this.loadMoreModel == LoadModel.ADVANCE_MODEL) {
            throw new RuntimeException("enableAdance Model cant not called closeLoadView method");
        }
        ((ILoadMoreView)this.mLoadMoreView).loadNothing();
        this.resetLoadMoreState();
        this.isNotMoreLoading = true;
    }

    private View getDefaultLoadMoreView() {
        return new SimpleLoadMoreView(this.getContext());
    }

    private int getLastVisiBleItem() {
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        int lastVisibleItemPosition = -1;
        int layoutManagerType = 0;
        if (layoutManager instanceof GridLayoutManager) {
            layoutManagerType = 1;
        } else if (layoutManager instanceof LinearLayoutManager) {
            layoutManagerType = 0;
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            layoutManagerType = 2;
        } else {
            throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
        }
        switch (layoutManagerType) {
            case 0: {
                lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case 1: {
                lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case 2: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                int[] lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                staggeredGridLayoutManager.findLastVisibleItemPositions(lastPositions);
                lastVisibleItemPosition = this.findMax(lastPositions);
            }
        }
        return lastVisibleItemPosition;
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public boolean isEnableLoadMore() {
        return this.loadMoreModel == LoadModel.COMMON_MODEL || this.loadMoreModel == LoadModel.ADVANCE_MODEL;
    }

    public LoadModel getLoadMoreModel() {
        return this.loadMoreModel;
    }

    public void setLoadMoreModel(LoadModel loadMoreModel, int advanceCount) {
        this.loadMoreModel = loadMoreModel;
        this.advanceCount = advanceCount;
    }

    public int getAdvanceCount() {
        return this.advanceCount;
    }

    public void setAdvanceCount(int advanceCount) {
        this.advanceCount = advanceCount;
    }

    public void setLoadMoreModel(LoadModel loadMoreModel) {
        this.setLoadMoreModel(loadMoreModel, 0);
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public long getShowLoadViewAnimatorDuration() {
        return SCROLL_TO_LOADING_DURATION;
    }

    public void setShowLoadViewAnimatorDuration(long scrollToLoadingDuration) {
        SCROLL_TO_LOADING_DURATION = scrollToLoadingDuration;
    }

    public int getScrollToRefreshDuration() {
        return SCROLL_TO_REFRESH_DURATION;
    }

    public void setScrollToRefreshDuration(int scrollToRefreshDuration) {
        SCROLL_TO_REFRESH_DURATION = scrollToRefreshDuration;
    }

    public int getScrollToTopDuration() {
        return SCROLL_TO_TOP_DURATION;
    }

    public void setScrollToTopDuration(int scrollToTopDuration) {
        SCROLL_TO_TOP_DURATION = scrollToTopDuration;
    }

    public long getHideLoadViewAnimatorDuration() {
        return SHOW_COMPLETED_TIME;
    }

    public void setHideLoadViewAnimatorDuration(long showCompletedTime) {
        SHOW_COMPLETED_TIME = showCompletedTime;
    }

    public double getPullResistance() {
        return this.pull_resistance;
    }

    public void setPullResistance(double PullResistance) {
        this.pull_resistance = PullResistance;
    }

    public static interface Event {
        public void complete();
    }

    public static interface LoadMoreEvent {
        public void onLoadMore();
    }

    public static interface EasyEvent
    extends OnRefreshListener,
    LoadMoreEvent {
    }

    public static interface OnRefreshListener {
        public void onRefreshing();
    }

    private class AutoScroll
    implements Runnable {
        private Scroller scroller;
        private int lastY;

        public AutoScroll() {
            this.scroller = new Scroller(EasyRefreshLayout.this.getContext());
        }

        @Override
        public void run() {
            boolean finished;
            boolean bl = finished = !this.scroller.computeScrollOffset() || this.scroller.isFinished();
            if (!finished) {
                int currY = this.scroller.getCurrY();
                int offset = currY - this.lastY;
                this.lastY = currY;
                EasyRefreshLayout.this.moveSpinner(offset);
                EasyRefreshLayout.this.post(this);
                EasyRefreshLayout.this.onScrollFinish(false);
            } else {
                this.stop();
                EasyRefreshLayout.this.onScrollFinish(true);
            }
        }

        public void scrollTo(int to, int duration) {
            int from = EasyRefreshLayout.this.currentOffsetTop;
            int distance = to - from;
            this.stop();
            if (distance == 0) {
                return;
            }
            this.scroller.startScroll(0, 0, 0, distance, duration);
            EasyRefreshLayout.this.post(this);
        }

        private void stop() {
            EasyRefreshLayout.this.removeCallbacks(this);
            if (!this.scroller.isFinished()) {
                this.scroller.forceFinished(true);
            }
            this.lastY = 0;
        }
    }
}

