/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.uiperformance;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import com.didichuxing.doraemonkit.model.ViewInfo;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.LifecycleListenerUtil;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.ArrayList;
import java.util.List;

public class UIPerformanceManager
implements LifecycleListenerUtil.LifecycleListener {
    private static final String TAG = "UIPerformanceManager";
    private Canvas mPerformanceCanvas;
    private List<PerformanceDataListener> mListeners = new ArrayList<PerformanceDataListener>();

    public static UIPerformanceManager getInstance() {
        return Holder.INSTANCE;
    }

    private UIPerformanceManager() {
    }

    public void start(Context context) {
        Bitmap canvasBitmap = Bitmap.createBitmap((int)UIUtils.getWidthPixels(), (int)UIUtils.getHeightPixels(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mPerformanceCanvas = new Canvas(canvasBitmap);
        LifecycleListenerUtil.registerListener(this);
    }

    public void stop() {
        this.mListeners.clear();
        this.mPerformanceCanvas = null;
        LifecycleListenerUtil.unRegisterListener(this);
    }

    public List<ViewInfo> getViewInfos(Activity activity) {
        if (activity == null) {
            LogHelper.d(TAG, "resume activity is null");
            return new ArrayList<ViewInfo>();
        }
        if (activity.getWindow() == null) {
            LogHelper.d(TAG, "resume activity window is null");
            return new ArrayList<ViewInfo>();
        }
        return this.getViewInfos(UIUtils.getDokitAppContentView(activity));
    }

    private List<ViewInfo> getViewInfos(View view) {
        ArrayList<ViewInfo> infos = new ArrayList<ViewInfo>();
        this.traverseViews(view, infos, 0);
        return infos;
    }

    private void traverseViews(View view, List<ViewInfo> infos, int layerNum) {
        if (view == null) {
            return;
        }
        ++layerNum;
        if (view instanceof ViewGroup) {
            int childCount = ((ViewGroup)view).getChildCount();
            if (childCount != 0) {
                for (int index = childCount - 1; index >= 0; --index) {
                    this.traverseViews(((ViewGroup)view).getChildAt(index), infos, layerNum);
                }
            }
        } else {
            ViewInfo viewInfo = new ViewInfo(view);
            try {
                if (view.getVisibility() == 0) {
                    float time;
                    long startTime = System.nanoTime();
                    if (this.mPerformanceCanvas != null) {
                        view.draw(this.mPerformanceCanvas);
                    }
                    long endTime = System.nanoTime();
                    viewInfo.drawTime = time = (float)((endTime - startTime) / 10000L) / 100.0f;
                    viewInfo.layerNum = layerNum;
                }
            }
            catch (Exception e) {
                viewInfo.drawTime = -1.0f;
                viewInfo.layerNum = -1;
            }
            infos.add(viewInfo);
        }
    }

    public void addListener(PerformanceDataListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(PerformanceDataListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void onActivityResumed(Activity activity) {
        for (PerformanceDataListener listener : this.mListeners) {
            listener.onRefresh(this.getViewInfos(activity));
        }
    }

    @Override
    public void onActivityPaused(Activity activity) {
    }

    @Override
    public void onFragmentAttached(Fragment f) {
        for (PerformanceDataListener listener : this.mListeners) {
            listener.onRefresh(this.getViewInfos((Activity)f.getActivity()));
        }
    }

    @Override
    public void onFragmentDetached(Fragment f) {
        for (PerformanceDataListener listener : this.mListeners) {
            listener.onRefresh(this.getViewInfos((Activity)f.getActivity()));
        }
    }

    public void initRefresh() {
        for (PerformanceDataListener listener : this.mListeners) {
            listener.onRefresh(this.getViewInfos(ActivityUtils.getTopActivity()));
        }
    }

    public static interface PerformanceDataListener {
        public void onRefresh(List<ViewInfo> var1);
    }

    private static class Holder {
        private static UIPerformanceManager INSTANCE = new UIPerformanceManager();

        private Holder() {
        }
    }
}

