/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.toolpanel.decoration;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.DimenRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.didichuxing.doraemonkit.kit.toolpanel.decoration.FlexibleDividerDecoration;

public class HorizontalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    protected HorizontalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent, View child) {
        Rect bounds = new Rect(0, 0, 0, 0);
        int transitionX = (int)ViewCompat.getTranslationX((View)child);
        int transitionY = (int)ViewCompat.getTranslationY((View)child);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        bounds.left = child.getLeft() + transitionX;
        bounds.right = child.getRight() + transitionX;
        int dividerSize = this.getDividerSize(position, parent);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE || this.mDividerType == FlexibleDividerDecoration.DividerType.SPACE) {
            if (this.alignLeftEdge(parent, position)) {
                bounds.left += this.mMarginProvider.dividerLeftMargin(position, parent);
            }
            bounds.right = this.alignRightEdge(parent, position) ? (bounds.right -= this.mMarginProvider.dividerRightMargin(position, parent)) : (bounds.right += this.getDividerSize(position, parent));
            bounds.top = child.getBottom() + params.bottomMargin + transitionY;
            bounds.bottom = bounds.top + dividerSize;
        } else {
            int halfSize = dividerSize / 2;
            bounds.bottom = bounds.top = child.getBottom() + params.bottomMargin + halfSize + transitionY;
        }
        if (this.mPositionInsideItem) {
            bounds.top -= dividerSize;
            bounds.bottom -= dividerSize;
        }
        return bounds;
    }

    private boolean alignLeftEdge(RecyclerView parent, int position) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)layoutManager;
            GridLayoutManager.SpanSizeLookup lookup = manager.getSpanSizeLookup();
            int spanCount = manager.getSpanCount();
            if (manager.getOrientation() == 1) {
                if (lookup.getSpanIndex(position, spanCount) == 0) {
                    return true;
                }
            } else {
                if (manager.getReverseLayout()) {
                    return lookup.getSpanGroupIndex(position, spanCount) == lookup.getSpanGroupIndex(parent.getAdapter().getItemCount() - 1, spanCount);
                }
                if (lookup.getSpanGroupIndex(position, spanCount) == 0) {
                    return true;
                }
            }
        } else {
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager manager = (StaggeredGridLayoutManager)layoutManager;
                StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(position).getLayoutParams();
                int spanCount = manager.getSpanCount();
                int spanIndex = params.getSpanIndex();
                if (manager.getOrientation() == 1) {
                    return spanIndex == 0;
                }
                if (manager.getReverseLayout()) {
                    int[] lastPosition = manager.findLastVisibleItemPositions(null);
                    boolean hasDirectionAlign = false;
                    for (int p : lastPosition) {
                        StaggeredGridLayoutManager.LayoutParams params1;
                        if (p == position || p == -1 || (params1 = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(p).getLayoutParams()).getSpanIndex() != spanIndex) continue;
                        hasDirectionAlign = true;
                        break;
                    }
                    return !hasDirectionAlign;
                }
                return position < spanCount;
            }
            if (layoutManager instanceof LinearLayoutManager) {
                return true;
            }
        }
        return false;
    }

    private boolean alignRightEdge(RecyclerView parent, int position) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)layoutManager;
            GridLayoutManager.SpanSizeLookup lookup = manager.getSpanSizeLookup();
            int spanCount = manager.getSpanCount();
            int itemCount = parent.getAdapter().getItemCount();
            if (manager.getOrientation() == 1) {
                if (this.positionTotalSpanSize(manager, position) == spanCount) {
                    return true;
                }
            } else {
                if (manager.getReverseLayout()) {
                    return lookup.getSpanGroupIndex(position, spanCount) == 0;
                }
                int lastRowFirstPosition = 0;
                for (int i = itemCount - 1; i >= 0; --i) {
                    if (lookup.getSpanIndex(i, spanCount) != 0) continue;
                    lastRowFirstPosition = i;
                    break;
                }
                if (position >= lastRowFirstPosition) {
                    return true;
                }
            }
        } else {
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager manager = (StaggeredGridLayoutManager)layoutManager;
                StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(position).getLayoutParams();
                int spanCount = manager.getSpanCount();
                int spanIndex = params.getSpanIndex();
                if (manager.getOrientation() == 1) {
                    return spanIndex == spanCount - 1;
                }
                if (manager.getReverseLayout()) {
                    return position < spanCount;
                }
                int[] lastPosition = manager.findLastVisibleItemPositions(null);
                boolean hasRight = false;
                for (int p : lastPosition) {
                    StaggeredGridLayoutManager.LayoutParams params1;
                    if (p == position || p == -1 || (params1 = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(p).getLayoutParams()).getSpanIndex() != spanIndex) continue;
                    hasRight = true;
                    break;
                }
                return !hasRight;
            }
            if (layoutManager instanceof LinearLayoutManager) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent) {
        if (this.mPositionInsideItem) {
            outRect.set(0, 0, 0, 0);
            return;
        }
        outRect.set(0, 0, 0, this.getDividerSize(position, parent));
    }

    private int getDividerSize(int position, RecyclerView parent) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable2 = this.mDrawableProvider.drawableProvider(position, parent);
            return drawable2.getIntrinsicHeight();
        }
        if (this.mSpaceProvider != null) {
            return this.mSpaceProvider.dividerSize(position, parent);
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerLeftMargin(int position, RecyclerView parent) {
                return 0;
            }

            @Override
            public int dividerRightMargin(int position, RecyclerView parent) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int leftMargin, final int rightMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerLeftMargin(int position, RecyclerView parent) {
                    return leftMargin;
                }

                @Override
                public int dividerRightMargin(int position, RecyclerView parent) {
                    return rightMargin;
                }
            });
        }

        public Builder margin(int horizontalMargin) {
            return this.margin(horizontalMargin, horizontalMargin);
        }

        public Builder marginResId(@DimenRes int leftMarginId, @DimenRes int rightMarginId) {
            return this.margin(this.mResources.getDimensionPixelSize(leftMarginId), this.mResources.getDimensionPixelSize(rightMarginId));
        }

        public Builder marginResId(@DimenRes int horizontalMarginId) {
            return this.marginResId(horizontalMarginId, horizontalMarginId);
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public HorizontalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new HorizontalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerLeftMargin(int var1, RecyclerView var2);

        public int dividerRightMargin(int var1, RecyclerView var2);
    }
}

