/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.layoutborder;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import androidx.fragment.app.Fragment;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.LayoutBorderConfig;
import com.didichuxing.doraemonkit.datapick.DataPickManager;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.core.UniversalActivity;
import com.didichuxing.doraemonkit.kit.layoutborder.LayoutBorderManager;
import com.didichuxing.doraemonkit.kit.layoutborder.ScalpelFrameLayout;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.LifecycleListenerUtil;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.util.UIUtils;

public class LayoutLevelDokitView
extends AbsDokitView {
    private static final String TAG = "LayoutLevelDokitView";
    private CheckBox mSwitchButton;
    private View mClose;
    private ScalpelFrameLayout mScalpelFrameLayout;
    private boolean mIsCheck;
    private LifecycleListenerUtil.LifecycleListener mLifecycleListener = new LifecycleListenerUtil.LifecycleListener(){

        @Override
        public void onActivityResumed(Activity activity) {
            LayoutLevelDokitView.this.resolveActivity(activity);
        }

        @Override
        public void onActivityPaused(Activity activity) {
        }

        @Override
        public void onFragmentAttached(Fragment f) {
        }

        @Override
        public void onFragmentDetached(Fragment f) {
        }
    };

    private void resolveActivity(Activity activity) {
        if (activity == null || activity instanceof UniversalActivity) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        ViewGroup appContentView = this.isNormalMode() ? (ViewGroup)UIUtils.getDokitAppContentView(activity) : (ViewGroup)window.getDecorView();
        if (appContentView == null) {
            ToastUtils.showShort((CharSequence)"\u5f53\u524d\u6839\u5e03\u5c40\u529f\u80fd\u4e0d\u652f\u6301");
            return;
        }
        if (appContentView.toString().contains("SwipeBackLayout")) {
            LogHelper.i(TAG, "\u666e\u901a\u6a21\u5f0f\u4e0b\u5e03\u5c40\u5c42\u7ea7\u529f\u80fd\u6682\u4e0d\u652f\u6301\u4ee5SwipeBackLayout\u4e3a\u6839\u5e03\u5c40,\u8bf7\u6539\u7528\u7cfb\u7edf\u6a21\u5f0f");
            ToastUtils.showLong((CharSequence)"\u666e\u901a\u6a21\u5f0f\u4e0b\u5e03\u5c40\u5c42\u7ea7\u529f\u80fd\u6682\u4e0d\u652f\u6301\u4ee5SwipeBackLayout\u4e3a\u6839\u5e03\u5c40");
            return;
        }
        this.mScalpelFrameLayout = new ScalpelFrameLayout(appContentView.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        while (appContentView.getChildCount() != 0) {
            View child = appContentView.getChildAt(0);
            if (child instanceof ScalpelFrameLayout) {
                this.mScalpelFrameLayout = (ScalpelFrameLayout)child;
                return;
            }
            appContentView.removeView(child);
            this.mScalpelFrameLayout.addView(child);
        }
        this.mScalpelFrameLayout.setLayerInteractionEnabled(this.mIsCheck);
        this.mScalpelFrameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        appContentView.addView((View)this.mScalpelFrameLayout);
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_layout_level, (ViewGroup)view, false);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.mSwitchButton = (CheckBox)this.findViewById(R.id.switch_btn);
        this.mSwitchButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    if (LayoutLevelDokitView.this.mScalpelFrameLayout != null) {
                        LayoutLevelDokitView.this.mScalpelFrameLayout.setLayerInteractionEnabled(true);
                    }
                    DataPickManager.getInstance().addData("dokit_sdk_ui_ck_widget_3d");
                } else if (LayoutLevelDokitView.this.mScalpelFrameLayout != null) {
                    LayoutLevelDokitView.this.mScalpelFrameLayout.setLayerInteractionEnabled(false);
                }
                LayoutLevelDokitView.this.mIsCheck = isChecked;
            }
        });
        this.mClose = this.findViewById(R.id.close);
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LayoutLevelDokitView.this.mScalpelFrameLayout != null) {
                    LayoutLevelDokitView.this.mScalpelFrameLayout.setLayerInteractionEnabled(false);
                }
                LayoutBorderConfig.setLayoutLevelOpen(false);
                LayoutBorderConfig.setLayoutBorderOpen(false);
                LayoutBorderManager.getInstance().stop();
                DoKit.removeFloating(LayoutLevelDokitView.class);
            }
        });
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.gravity = 1;
        params.x = 0;
        params.y = UIUtils.getHeightPixels() - UIUtils.dp2px(125.0f);
        params.width = this.getScreenShortSideLength();
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
    }

    @Override
    public void onCreate(Context context) {
        this.resolveActivity(ActivityUtils.getTopActivity());
        LifecycleListenerUtil.registerListener(this.mLifecycleListener);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mScalpelFrameLayout != null) {
            this.mScalpelFrameLayout.setLayerInteractionEnabled(false);
            this.mScalpelFrameLayout = null;
        }
        LifecycleListenerUtil.unRegisterListener(this.mLifecycleListener);
    }
}

