/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.health;

import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.UploadAppHealthCallback;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.dialog.DialogListener;
import com.didichuxing.doraemonkit.widget.dialog.DialogProvider;

public class UserInfoDialogProvider<T>
extends DialogProvider<T> {
    private TextView mPositive;
    private TextView mNegative;
    private TextView mClose;
    private EditText mCaseName;
    private EditText mUserName;

    UserInfoDialogProvider(T data, DialogListener listener) {
        super(data, listener);
    }

    @Override
    public int getLayoutId() {
        return R.layout.dk_dialog_userinfo;
    }

    @Override
    protected void findViews(View view) {
        this.mPositive = (TextView)view.findViewById(R.id.positive);
        this.mNegative = (TextView)view.findViewById(R.id.negative);
        this.mClose = (TextView)view.findViewById(R.id.close);
        this.mCaseName = (EditText)view.findViewById(R.id.edit_case_name);
        this.mUserName = (EditText)view.findViewById(R.id.edit_user_name);
    }

    @Override
    protected void bindData(Object data) {
    }

    @Override
    protected View getPositiveView() {
        return this.mPositive;
    }

    @Override
    protected View getNegativeView() {
        return this.mNegative;
    }

    @Override
    protected View getCancelView() {
        return this.mClose;
    }

    boolean uploadAppHealthInfo(UploadAppHealthCallback uploadAppHealthCallBack) {
        if (!this.userInfoCheck()) {
            ToastUtils.showShort((CharSequence)"\u8bf7\u586b\u5199\u6d4b\u8bd5\u7528\u4f8b\u548c\u6d4b\u8bd5\u4eba");
            return false;
        }
        String caseName = this.mCaseName.getText().toString();
        String userName = this.mUserName.getText().toString();
        AppHealthInfoUtil.getInstance().setBaseInfo(caseName, userName);
        try {
            AppHealthInfoUtil.getInstance().post(uploadAppHealthCallBack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean userInfoCheck() {
        if (this.mCaseName == null || TextUtils.isEmpty((CharSequence)this.mCaseName.getText().toString())) {
            return false;
        }
        return this.mUserName != null && !TextUtils.isEmpty((CharSequence)this.mUserName.getText().toString());
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

